<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

/*
 * @hooked wc_empty_cart_message - 10
 */
do_action( 'woocommerce_cart_is_empty' );?>
<div class="orion-empty-cart text-center">
	<div class="orion-svg">
		<svg width="157px" height="119px" viewBox="0 0 157 119" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
		    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
		        <g id="basket" transform="translate(0.000000, -1.000000)" fill-rule="nonzero" fill="#828282">
		            <path d="M147.367178,53.0578512 L9.3270366,53.0578512 C8.75249115,53.0578512 8.20779221,53.3219008 7.85336482,53.7719008 C7.49893743,54.2219008 7.37582054,54.8095041 7.51386068,55.3673554 L22.4595041,114.934711 C22.8176623,116.188017 23.9182527,120 27.9811098,120 L128.713105,120 C132.790885,120 133.880283,116.184298 134.253365,114.871488 L149.176623,55.3673554 C149.314664,54.8132231 149.191547,54.2219008 148.837119,53.7719008 C148.486423,53.3219008 147.941724,53.0578512 147.367178,53.0578512 Z M130.653129,113.911983 C129.97412,116.280992 129.272727,116.280992 128.713105,116.280992 L27.9811098,116.280992 C27.4252184,116.280992 26.7275561,116.280992 26.0597403,113.971488 L11.7184888,56.7768595 L144.979457,56.7768595 L130.653129,113.911983 Z" id="Shape"></path>
		            <path d="M69.0200708,105.123967 C70.0497757,105.123967 70.8854782,104.290909 70.8854782,103.264463 L70.8854782,69.7933884 C70.8854782,68.7669421 70.0497757,67.9338843 69.0200708,67.9338843 C67.990366,67.9338843 67.1546635,68.7669421 67.1546635,69.7933884 L67.1546635,103.264463 C67.1546635,104.290909 67.990366,105.123967 69.0200708,105.123967 Z" id="Shape"></path>
		            <path d="M42.9006375,105.123967 C42.971523,105.123967 43.0386777,105.120248 43.113294,105.11281 C44.1355372,104.997521 44.8742385,104.078926 44.7585832,103.059917 L41.0277686,69.588843 C40.9158442,68.5661157 40.0204486,67.8446281 38.9646281,67.9450413 C37.9423849,68.0603306 37.2036836,68.9789256 37.3193388,69.9979339 L41.0501535,103.469008 C41.1546163,104.421074 41.9642031,105.123967 42.9006375,105.123967 Z" id="Shape"></path>
		            <path d="M91.4049587,105.123967 C92.4346635,105.123967 93.270366,104.290909 93.270366,103.264463 L93.270366,69.7933884 C93.270366,68.7669421 92.4346635,67.9338843 91.4049587,67.9338843 C90.3752538,67.9338843 89.5395514,68.7669421 89.5395514,69.7933884 L89.5395514,103.264463 C89.5395514,104.290909 90.3752538,105.123967 91.4049587,105.123967 Z" id="Shape"></path>
		            <path d="M113.580921,105.11281 C113.655537,105.120248 113.722692,105.123967 113.793577,105.123967 C114.730012,105.123967 115.539599,104.421074 115.644061,103.469008 L119.374876,69.9979339 C119.4868,68.9789256 118.75183,68.0603306 117.729587,67.9450413 C116.658843,67.8409091 115.782102,68.5661157 115.666446,69.588843 L111.935632,103.059917 C111.823707,104.078926 112.558678,104.997521 113.580921,105.11281 Z" id="Shape"></path>
		            <path d="M128.713105,45.6198347 C129.14588,45.6198347 129.578654,45.4710744 129.933081,45.1661157 C130.712822,44.4929752 130.7949,43.3214876 130.123353,42.5442149 L94.6806139,1.63512397 C94.0053365,0.854132231 92.8301299,0.776033058 92.0503896,1.44173554 C91.2706494,2.11487603 91.1885714,3.28636364 91.8601181,4.06363636 L127.302857,44.9727273 C127.672208,45.4004132 128.190791,45.6198347 128.713105,45.6198347 Z" id="Shape"></path>
		            <path d="M66.4681936,1.41198347 C65.6735301,0.768595041 64.4983235,0.876446281 63.8454309,1.67603306 L30.2680992,42.585124 C29.6152066,43.3772727 29.7308619,44.5487603 30.5292562,45.2033058 C30.876222,45.4822314 31.297804,45.6198347 31.7119244,45.6198347 C32.2528926,45.6198347 32.7863991,45.3892562 33.1557497,44.9355372 L66.7330815,4.02644628 C67.385974,3.23429752 67.266588,2.06280992 66.4681936,1.41198347 Z" id="Shape"></path>
		            <path d="M154.828808,38.1818182 L139.905549,38.1818182 C138.875844,38.1818182 138.040142,39.014876 138.040142,40.0413223 C138.040142,41.0677686 138.875844,41.9008264 139.905549,41.9008264 L154.828808,41.9008264 C155.858512,41.9008264 156.694215,41.0677686 156.694215,40.0413223 C156.694215,39.014876 155.858512,38.1818182 154.828808,38.1818182 Z" id="Shape"></path>
		            <path d="M50.3659976,41.9008264 L110.059032,41.9008264 C111.088737,41.9008264 111.924439,41.0677686 111.924439,40.0413223 C111.924439,39.014876 111.088737,38.1818182 110.059032,38.1818182 L50.3659976,38.1818182 C49.3362928,38.1818182 48.5005903,39.014876 48.5005903,40.0413223 C48.5005903,41.0677686 49.3362928,41.9008264 50.3659976,41.9008264 Z" id="Shape"></path>
		            <path d="M1.86540732,41.9008264 L20.5194805,41.9008264 C21.5491854,41.9008264 22.3848878,41.0677686 22.3848878,40.0413223 C22.3848878,39.014876 21.5491854,38.1818182 20.5194805,38.1818182 L1.86540732,38.1818182 C0.835702479,38.1818182 0,39.014876 0,40.0413223 C0,41.0677686 0.835702479,41.9008264 1.86540732,41.9008264 Z" id="Shape"></path>
		        </g>
		    </g>
		</svg>
	</div>
<?php

echo '<h5 class="cart-empty text-uppercase">' . apply_filters( 'wc_empty_cart_message', __( 'Your cart is currently empty.', 'woocommerce' ) ) . '</h5>';

if ( wc_get_page_id( 'shop' ) > 0 ) : ?>
	<p class="return-to-shop">
		<a class="wc-backward btn btn-md btn-c1<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
			<?php echo esc_html( apply_filters( 'woocommerce_return_to_shop_text', __( 'Return to shop', 'woocommerce' ) ) ); ?>
		</a>
	</p>
<?php endif; ?>
</div>