<?php 
/**
 * DEVELOPER GUIDE:
 *
 * 1. Child theme function overrides: 
 * Orion themes use if (!function_exists wrapper()){} for all functions. 
 * To change a specific function, just copy existing function to your child theme and customize it.
 * if (!function_exists('dentalia_function')) {}
 *
 * *
 *
 *
 * TOC:
 * * TEMPLATE FUNCTIONS
 * * FILTER FUNCTIONS
 */ 
 
/************************************* O.o *************************************/
/*                             TEMPLATE FUNCTIONS                              */ 
/*******************************************************************************/

/**
 * @return template
 */

if(!function_exists('orion_get_top_bar')) {
	function orion_get_top_bar() {	
	global $orion_options;	
	if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
	}	
	if (isset($orion_options['top_bar_onoff']) && $orion_options['top_bar_onoff']==1) {
		return( get_template_part( 'templates/header/topbar', 'leftright' ));}
	}
}
/* favicon support */
function orion_site_icon_sizes($sizes) {
	$sizes = array(16, 32, 64, 72, 120);
    return $sizes;
}
add_filter('site_icon_image_sizes', 'orion_site_icon_sizes');

function orion_site_icon_meta_tags($tags) {
    $tags[] = sprintf('<link rel="icon" href="%s" sizes="16x16" />', esc_url(get_site_icon_url(null, 16)));
    $tags[] = sprintf('<link rel="icon" href="%s" sizes="32x32" />', esc_url(get_site_icon_url(null, 32)));
    $tags[] = sprintf('<link rel="icon" href="%s" sizes="64x64" />', esc_url(get_site_icon_url(null, 64)));
    $tags[] = sprintf('<link rel="icon" href="%s" sizes="72x72" />', esc_url(get_site_icon_url(null, 72)));
    $tags[] = sprintf('<link rel="icon" href="%s" sizes="120x120" />', esc_url(get_site_icon_url(null, 120)));

    return $tags;
}
add_filter('site_icon_meta_tags', 'orion_site_icon_meta_tags');

/* Global defaults */
if(!function_exists('orion_get_orion_defaults')) {
	function orion_get_orion_defaults() {	

	$orion_defauls = array (
	  'last_tab' => '',
	  'main_theme_color' => '#00b2ca',
	  'secondary_theme_color' => '#3F51B5',
	  'color_3' => '#2B354B',
	  'site_background_color' => '#ffffff',
	  'alt_site_background_color' => '#f4f8fa',
	  'green_color' => '#8bc34a',
	  'blue_color' => '#29b6f6',
	  'pink_color' => '#ec407a',
	  'orange_color' => '#ffa726',
	  'boxed_fullwidth' => '1',
	  'passepartout' => '0',
	  'passepartout_size' => 
	  array (
	    'width' => '24',
	    'height' => '24',
	  ),
	  'passepartout_color' => '#e0e0e0',
	  'boxed_site_width' => '1320',
	  'boxed_site_padding' => '90',
	  'boxed_top_margin' => 
	  array (
	    'units' => 'px',
	    'margin-top' => '36px',
	    'margin-bottom' => '36px',
	  ),
	  'boxed_site_background_color' => '#f4f8fa',
	  'pattern_type' => '1',
	  'boxed_site_background' => 
	  array (
	    'background-repeat' => '',
	    'background-size' => '',
	    'background-attachment' => '',
	    'background-position' => '',
	    'background-image' => '',
	    'media' => 
	    array (
	      'id' => '',
	      'height' => '',
	      'width' => '',
	      'thumbnail' => '',
	    ),
	  ),
	  'boxed_add_shadow' => '0',
	  'boxed_site_shadow_color' => 
	  array (
	    'color' => '#00b2ca',
	    'alpha' => '0.15',
	    'rgba' => 'rgba(0,178,202,0.15)',
	  ),
	  'boxed_border_radius' => '0',
	  'page-sidebar-left-defauts' => '',
	  'page-sidebar-right-defauts' => '',
	  'page_404' => '',
	  'back_to_top' => '0',
	  'one_page' => '0',
	  'comments_posts' => '1',
	  'comments_pages' => '0',
	  'comments_attachment' => '0',
	  'use_minified_css' => '1',
	  'custom_head_tags' => '',
	  'custom_body_tags' => '',
	  'custom_footer_tags' => '',
	  'upgrade_to' => 1714378707,
	  'orion_carousel' => 'tiny-slider',
	  'load_fa' => '0',
	  'load_ei' => '0',
	  'logo_upload_dark' => 
	  array (
	    'url' => 'https://downloads.orionthemes.com/demo-content/dentalia-2_3/wp-content/uploads/2016/10/dentalia-logo.png',
	    'id' => '953',
	    'height' => '60',
	    'width' => '236',
	    'thumbnail' => 'https://downloads.orionthemes.com/demo-content/dentalia-2_3/wp-content/uploads/2016/10/dentalia-logo-150x60.png',
	  ),
	  'logo_upload_light' => 
	  array (
	    'url' => 'https://downloads.orionthemes.com/demo-content/dentalia-2_3/wp-content/uploads/2016/10/dentalia-logo-light.png',
	    'id' => '952',
	    'height' => '60',
	    'width' => '236',
	    'thumbnail' => 'https://downloads.orionthemes.com/demo-content/dentalia-2_3/wp-content/uploads/2016/10/dentalia-logo-light-150x60.png',
	  ),
	  'logo_upload_sticky' => 
	  array (
	    'url' => 'https://downloads.orionthemes.com/demo-content/dentalia-2_3/wp-content/uploads/2017/05/dentalia-sticky-logo.png',
	    'id' => '2433',
	    'height' => '60',
	    'width' => '190',
	    'thumbnail' => 'https://downloads.orionthemes.com/demo-content/dentalia-2_3/wp-content/uploads/2017/05/dentalia-sticky-logo-150x60.png',
	  ),
	  'text_logo' => 'Dentalia',
	  'logo_max_dimensions' => 
	  array (
	    'width' => '',
	    'height' => '',
	  ),
	  'orion_header_type' => 'classic',
	  'header_hight_classic' => '120',
	  'logo_position_hight_classic' => '50',
	  'header_width_classic' => '0',
	  'use_additional_breaking_point' => '0',
	  'classicheader_breaking_point' => '1160',
	  'header_hight_classic_centered' => '84',
	  'logo_mobile_spacing_br' => 
	  array (
	    'units' => 'px',
	    'padding-top' => '30px',
	    'padding-bottom' => '6px',
	  ),
	  'classic_header_background' => 
	  array (
	    'background-color' => '',
	    'background-repeat' => '',
	    'background-size' => '',
	    'background-position' => '',
	    'background-image' => '',
	    'media' => 
	    array (
	      'id' => '',
	      'height' => '',
	      'width' => '',
	      'thumbnail' => '',
	    ),
	  ),
	  'classicheader_widgets_switch' => '1',
	  'classic_headerwidgets_background_color' => '',
	  'classicheader_widgets_colorstyle' => 'text-dark',
	  'classic_header_widgets_spacing' => 
	  array (
	    'units' => 'px',
	    'padding-top' => '24px',
	    'padding-bottom' => '12px',
	  ),
	  'header_hight_with_widgets' => '96',
	  'navbar_hight_with_widgets' => '96',
	  'logo_position_hight_with_widgets' => '50',
	  'header_width_with_widgets' => '0',
	  'header_background' => 
	  array (
	    'background-color' => '#ffffff',
	    'background-repeat' => '',
	    'background-size' => '',
	    'background-position' => '',
	    'background-image' => '',
	    'media' => 
	    array (
	      'id' => '',
	      'height' => '',
	      'width' => '',
	      'thumbnail' => '',
	    ),
	  ),
	  'header_widgets_colorstyle' => 'text-dark',
	  'widgetsfluid_widgets_switch' => '1',
	  'header_widgets_width' => 'col-md-8',
	  'header_widgets_width_fixed' => '500',
	  'widgetsfluid_header_widgets_spacing' => 
	  array (
	    'units' => 'px',
	    'padding-top' => '24px',
	    'padding-bottom' => '12px',
	  ),
	  'mobile_header_layout' => 'mobile-header-classic',
	  'logo_mobile_spacing' => 
	  array (
	    'units' => 'px',
	    'padding-top' => '',
	    'padding-bottom' => '',
	  ),
	  'mobile_navigation_call_us_icon' => '',
	  'classicheader_widgets_mobile_display' => 'in_navigation',
	  'classic_header_widgets_spacing_mobile_widgets' => 
	  array (
	    'units' => 'px',
	    'padding-top' => '48px',
	    'padding-bottom' => '12px',
	  ),
	  'classicheader_widgets_colorstyle_mobile' => 'mobile-text-default-color',
	  'classicheader_mobile_logo_color' => 'mobile-text-dark',
	  'widgetsfluid_header_mobile_logo_color' => 'mobile-text-dark',
	  'header_widgets_colorstyle_mobile' => 'mobile-text-default',
	  'is_header_sticky' => '0',
	  'sticky_header_background' => 
	  array (
	    'background-color' => '#fff',
	    'background-repeat' => '',
	    'background-size' => '',
	    'background-attachment' => '',
	    'background-position' => '',
	    'background-image' => '',
	    'media' => 
	    array (
	      'id' => '',
	      'height' => '',
	      'width' => '',
	      'thumbnail' => '',
	    ),
	  ),
	  'sticky_navigation_links_color_style' => '',
	  'sticky_navigation_style' => '',
	  'top_bar_onoff' => '0',
	  'topbar_text_color' => 'text-dark',
	  'topbar_background' => '#ffffff',
	  'topbar_divider_left' => '1',
	  'topbar_divider_right' => '1',
	  'topbar_border_color' => 
	  array (
	    'color' => '#f2f2f2',
	    'alpha' => '1',
	    'rgba' => 'rgba(242,242,242,1)',
	  ),
	  'is_top_bar_fluid' => '0',
	  'is_top_bar_always_open' => '0',
	  'navigation_links_color_style' => 'nav-light',
	  'navigation_style' => 'nav-style-2',
	  'navigation_submenu_shadow' => 'default',
	  'nav_item_padding' => 
	  array (
	    'width' => '',
	  ),
	  'first-lvl-menu' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-weight' => '',
	    'font-style' => '',
	    'subsets' => '',
	    'text-transform' => 'uppercase',
	    'font-size' => '12px',
	    'letter-spacing' => '1px',
	  ),
	  'second-lvl-menu' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-weight' => '',
	    'font-style' => '',
	    'subsets' => '',
	    'text-transform' => 'uppercase',
	    'font-size' => '12px',
	    'letter-spacing' => '1px',
	  ),
	  'display_header_button' => '0',
	  'button_text' => 'Button',
	  'button_link_url' => '#',
	  'header_button_new_tab' => '0',
	  'last_tab_size' => 's36',
	  'header_button_color' => 'btn-c2',
	  'header_button_rounding' => 'btn-slightly-rounded',
	  'orion_megamenu' => '1',
	  'mega_menu_background' => 
	  array (
	    'background-repeat' => '',
	    'background-size' => '',
	    'background-attachment' => '',
	    'background-position' => '',
	    'background-image' => '',
	    'media' => 
	    array (
	      'id' => '',
	      'height' => '',
	      'width' => '',
	      'thumbnail' => '',
	    ),
	  ),
	  'mega_menu_borders' => 'mega-light-borders',
	  'search_icon' => '1',
	  'site_search_bg_color' => '#2B354B',
	  'nav_menu_bg_color_nav_light' => '',
	  'first_lvl_menu_colors_nav_light' => 
	  array (
	    'regular' => '#212121',
	    'hover' => '#212121',
	    'active' => '#ffffff',
	  ),
	  'first_lvl_menu_bg_nav_light' => 
	  array (
	    'regular' => '',
	    'hover' => '',
	    'active' => '',
	  ),
	  'submenu_colors_nav_light' => 
	  array (
	    'regular' => '#ffffff',
	    'hover' => '',
	    'active' => '',
	  ),
	  'submenu_background_nav_light' => 
	  array (
	    'color' => '',
	    'alpha' => '1',
	    'rgba' => '',
	  ),
	  'submenu_border_nav_light' => 
	  array (
	    'color' => '#000',
	    'alpha' => '0.2',
	    'rgba' => 'rgba(0,0,0,0.2)',
	  ),
	  'nav_menu_bg_color_nav_dark' => '',
	  'first_lvl_menu_colors_nav_dark' => 
	  array (
	    'regular' => '',
	    'hover' => '',
	    'active' => '',
	  ),
	  'first_lvl_menu_bg_nav_dark' => 
	  array (
	    'regular' => '',
	    'hover' => '',
	    'active' => '',
	  ),
	  'submenu_colors_nav_dark' => 
	  array (
	    'regular' => '#212121',
	    'hover' => '',
	    'active' => '',
	  ),
	  'submenu_background_nav_dark' => 
	  array (
	    'color' => '#fff',
	    'alpha' => '1',
	    'rgba' => 'rgba(255,255,255,1)',
	  ),
	  'submenu_border_nav_dark' => 
	  array (
	    'color' => '#000',
	    'alpha' => '0.05',
	    'rgba' => 'rgba(0,0,0,0.05)',
	  ),
	  'mobile_navigation_parent' => 'nav_open_submenu',
	  'mobile_menu_background' => '',
	  'woo_cart_mobile_text_color' => 'auto',
	  'mobile_menu_link_colors' => 
	  array (
	    'regular' => '',
	    'active' => '',
	  ),
	  'post_heading_type' => 'classic',
	  'default_overlay' => '',
	  'title_single_post_onoff' => '0',
	  'post-heading-background-classic' => 
	  array (
	    'background-color' => '',
	    'background-repeat' => 'no-repeat',
	    'background-size' => 'cover',
	    'background-attachment' => '',
	    'background-position' => 'center center',
	    'background-image' => '',
	    'media' => 
	    array (
	      'id' => '',
	      'height' => '',
	      'width' => '',
	      'thumbnail' => '',
	    ),
	  ),
	  'post-heading-padding-classic' => 
	  array (
	    'units' => 'px',
	    'padding-top' => '30px',
	    'padding-bottom' => '30px',
	  ),
	  'heading-onoff-classic' => '1',
	  'post-heading-title-classic' => 
	  array (
	    'font-family' => 'Montserrat',
	    'font-options' => '',
	    'google' => '1',
	    'font-weight' => '400',
	    'font-style' => '',
	    'subsets' => '',
	    'text-transform' => 'capitalize',
	    'font-size' => '21px',
	    'line-height' => '24px',
	    'word-spacing' => '',
	    'letter-spacing' => '1px',
	    'color' => '#fff',
	  ),
	  'crumbs-onoff-classic' => '1',
	  'crumbs-font-classic' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-weight' => '400',
	    'font-style' => '',
	    'subsets' => '',
	    'font-size' => '12px',
	    'letter-spacing' => '1px',
	    'color' => '#ffffff',
	  ),
	  'post-heading-background-centered' => 
	  array (
	    'background-color' => '',
	    'background-repeat' => 'no-repeat',
	    'background-size' => 'cover',
	    'background-attachment' => '',
	    'background-position' => 'center center',
	    'background-image' => '',
	    'media' => 
	    array (
	      'id' => '',
	      'height' => '',
	      'width' => '',
	      'thumbnail' => '',
	    ),
	  ),
	  'post-heading-padding-centered' => 
	  array (
	    'units' => 'px',
	    'padding-top' => '72px',
	    'padding-bottom' => '60px',
	  ),
	  'heading-onoff-centered' => '1',
	  'post-heading-title-centered' => 
	  array (
	    'font-family' => 'Montserrat',
	    'font-options' => '',
	    'google' => '1',
	    'font-weight' => '400',
	    'font-style' => '',
	    'subsets' => '',
	    'text-transform' => 'capitalize',
	    'font-size' => '31px',
	    'line-height' => '36px',
	    'word-spacing' => '',
	    'letter-spacing' => '',
	    'color' => '#fff',
	  ),
	  'crumbs-onoff-centered' => '1',
	  'crumbs-font-centered' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-weight' => '400',
	    'font-style' => '',
	    'subsets' => '',
	    'font-size' => '12px',
	    'letter-spacing' => '1px',
	    'color' => '#ffffff',
	  ),
	  'post-heading-background-left' => 
	  array (
	    'background-color' => '',
	    'background-repeat' => 'no-repeat',
	    'background-size' => 'cover',
	    'background-attachment' => '',
	    'background-position' => 'center center',
	    'background-image' => '',
	    'media' => 
	    array (
	      'id' => '',
	      'height' => '',
	      'width' => '',
	      'thumbnail' => '',
	    ),
	  ),
	  'post-heading-padding-left' => 
	  array (
	    'units' => 'px',
	    'padding-top' => '120px',
	    'padding-bottom' => '120px',
	  ),
	  'heading-onoff-left' => '1',
	  'post-heading-title-left' => 
	  array (
	    'font-family' => 'Montserrat',
	    'font-options' => '',
	    'google' => '1',
	    'font-weight' => '400',
	    'font-style' => '',
	    'subsets' => '',
	    'text-transform' => 'capitalize',
	    'font-size' => '44px',
	    'line-height' => '48px',
	    'word-spacing' => '',
	    'letter-spacing' => '',
	    'color' => '',
	  ),
	  'crumbs-onoff-left' => '1',
	  'crumbs-font-left' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-weight' => '400',
	    'font-style' => '',
	    'subsets' => '',
	    'font-size' => '12px',
	    'letter-spacing' => '1px',
	    'color' => '#ffffff',
	  ),
	  'uncoveringfooter_switch' => '',
	  'mainfooter-sidebars' => '1',
	  'footer_text_colors' => 'auto',
	  'footer_background' => 
	  array (
	    'background-color' => '',
	    'background-repeat' => '',
	    'background-size' => '',
	    'background-position' => '',
	    'background-image' => '',
	    'media' => 
	    array (
	      'id' => '',
	      'height' => '',
	      'width' => '',
	      'thumbnail' => '',
	    ),
	  ),
	  'footer_spacing' => 
	  array (
	    'units' => 'px',
	    'padding-top' => '60px',
	    'padding-bottom' => '60px',
	  ),
	  'prefooter_switch' => '1',
	  'prefooter-sidebars' => '1',
	  'prefooter_text_colors' => '',
	  'prefooter_background' => 
	  array (
	    'background-color' => '#fff',
	    'background-repeat' => '',
	    'background-size' => '',
	    'background-position' => '',
	    'background-image' => '',
	    'media' => 
	    array (
	      'id' => '',
	      'height' => '',
	      'width' => '',
	      'thumbnail' => '',
	    ),
	  ),
	  'prefooter_spacing' => 
	  array (
	    'units' => 'px',
	    'padding-top' => '60px',
	    'padding-bottom' => '24px',
	  ),
	  'copyrightarea_switch' => '1',
	  'copyrightfooter-sidebars' => '1',
	  'copyright_text_colors' => 'auto',
	  'copyright_background' => 
	  array (
	    'background-color' => '',
	    'background-repeat' => '',
	    'background-size' => '',
	    'background-position' => '',
	    'background-image' => '',
	    'media' => 
	    array (
	      'id' => '',
	      'height' => '',
	      'width' => '',
	      'thumbnail' => '',
	    ),
	  ),
	  'copyright_footer_spacing' => 
	  array (
	    'units' => 'px',
	    'padding-top' => '17px',
	    'padding-bottom' => '17px',
	  ),
	  'content_font' => 
	  array (
	    'font-family' => 'Open Sans',
	    'font-options' => '',
	    'google' => '1',
	    'subsets' => '',
	  ),
	  'title_font' => 
	  array (
	    'font-family' => 'Montserrat',
	    'font-options' => '',
	    'google' => '1',
	    'subsets' => '',
	  ),
	  'button_nav_font' => 
	  array (
	    'font-family' => 'Montserrat',
	    'font-options' => '',
	    'google' => '1',
	    'subsets' => '',
	  ),
	  'paragraph_colors_dark' => '#959595',
	  'heading_colors_dark' => '#595959',
	  'link_colors_dark' => 
	  array (
	    'regular' => '#212121',
	    'hover' => '',
	    'active' => '',
	  ),
	  'paragraph_colors_light' => '#ffffff',
	  'heading_colors_light' => '#ffffff',
	  'link_colors_light' => 
	  array (
	    'regular' => '#ffffff',
	    'hover' => '',
	    'active' => '',
	  ),
	  'body-font' => 
	  array (
	    'font-family' => 'Open Sans',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '400',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '15px',
	    'line-height' => '24px',
	    'word-spacing' => '',
	    'letter-spacing' => '',
	  ),
	  'body_font_in_widgets_and_footer' => 
	  array (
	    'font-size' => '12px',
	    'line-height' => '24px',
	  ),
	  'lead-font' => 
	  array (
	    'font-family' => 'Open Sans',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '400',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '21px',
	    'line-height' => '36px',
	    'word-spacing' => '',
	    'letter-spacing' => '',
	  ),
	  'small-font' => 
	  array (
	    'font-family' => 'Open Sans',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '400',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '12px',
	    'line-height' => '12px',
	    'word-spacing' => '',
	    'letter-spacing' => '1px',
	  ),
	  'h1-font' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '39px',
	    'line-height' => '48px',
	    'word-spacing' => '',
	    'letter-spacing' => '',
	  ),
	  'h2-font' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '33px',
	    'line-height' => '36px',
	    'word-spacing' => '',
	    'letter-spacing' => '',
	  ),
	  'h3-font' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '27px',
	    'line-height' => '36px',
	    'word-spacing' => '',
	    'letter-spacing' => '',
	  ),
	  'h4-font' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '24px',
	    'line-height' => '30px',
	    'word-spacing' => '',
	    'letter-spacing' => '',
	  ),
	  'h5-font' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '21px',
	    'line-height' => '24px',
	    'word-spacing' => '',
	    'letter-spacing' => '',
	  ),
	  'h6-font' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '18px',
	    'line-height' => '24px',
	    'word-spacing' => '',
	    'letter-spacing' => '',
	  ),
	  'default_btn_color' => '#959595',
	  'btn_font_weight' => 
	  array (
	    'font-weight' => '500',
	    'font-style' => '',
	    'text-transform' => '',
	  ),
	  'btn-lg' => 
	  array (
	    'font-size' => '15px',
	  ),
	  'btn-md' => 
	  array (
	    'font-size' => '12px',
	  ),
	  'btn-sm' => 
	  array (
	    'font-size' => '12px',
	  ),
	  'btn-xs' => 
	  array (
	    'font-size' => '11px',
	  ),
	  'display_1' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '61px',
	    'line-height' => '66px',
	    'word-spacing' => '',
	    'letter-spacing' => '',
	  ),
	  'display_1_font_mobile' => 
	  array (
	    'font-size' => '44px',
	    'line-height' => '48px',
	  ),
	  'display_2' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '39px',
	    'line-height' => '48px',
	    'word-spacing' => '',
	    'letter-spacing' => '0',
	  ),
	  'display_2_font_mobile' => 
	  array (
	    'font-size' => '33px',
	    'line-height' => '36px',
	  ),
	  'display_3' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-backup' => '',
	    'font-weight' => '',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => '',
	    'font-size' => '18px',
	    'line-height' => '24px',
	    'word-spacing' => '',
	    'letter-spacing' => '3px',
	  ),
	  'display_3_font_mobile' => 
	  array (
	    'font-size' => '18px',
	    'line-height' => '24px',
	  ),
	  'blog_layout' => 'classic',
	  'blog_readme_button' => 'btn',
	  'blog_date_on_image' => '0',
	  'postmeta_settings' => 
	  array (
	    1 => '1',
	    2 => '1',
	    3 => '1',
	    4 => '1',
	  ),
	  'entry_heading' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-weight' => '400',
	    'font-style' => '',
	    'subsets' => '',
	    'text-align' => '',
	    'text-transform' => 'capitalize',
	    'font-size' => '30px',
	    'line-height' => '36px',
	    'letter-spacing' => '',
	  ),
	  'post_meta' => 
	  array (
	    'font-family' => '',
	    'font-options' => '',
	    'google' => '1',
	    'font-weight' => '400',
	    'font-style' => '',
	    'subsets' => '',
	    'text-transform' => '',
	    'font-size' => '13px',
	    'line-height' => '13px',
	  ),
	  'archive_blog_sidebar_left_defaults' => '',
	  'archive_blog_sidebar_right_defaults' => 'sidebar-default',
	  'post-sidebar-left-defauts' => '',
	  'post-sidebar-right-defauts' => 'sidebar-default',
	  'share-icons' => 
	  array (
	    'facebook' => '1',
	    'twitter' => '1',
	    'linkedin' => '1',
	  ),
	  'use_team_post_type' => '1',
	  'team_display_intro_text' => '1',
	  'woo_products_per_page' => '12',
	  'woo_cart' => '1',
	  'sale_tag_color' => '',
	  'woo_sidebar_left' => '',
	  'woo_sidebar_right' => '',
	  'add-sidebars' => 
	  array (
	    0 => 'Orion custom sidebar',
	    1 => 'Blog sidebar',
	  ),
	  'orion_custom_css_editor' => '',
	  'pattern' => '',
	);
	
	return $orion_defauls;
	}
}

/**
 * @return header template
 */
if(!function_exists('orion_get_header')) {
	function orion_get_header() {
		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}		

		if (isset($orion_options["orion_header_type"])) {
			return( get_template_part( 'templates/header/header', $orion_options["orion_header_type"] ));
		} else	{
			return( get_template_part( 'templates/header/header', 'classic' ));
		}
	}
}

if(!function_exists('orion_get_stickyHeader')) {
	function orion_get_stickyHeader() {
		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}		
		if (isset($orion_options["is_header_sticky"]) && $orion_options["is_header_sticky"] == '1') {
			return( get_template_part( 'templates/header/header', 'sticky' ));
		}
	}
} 

/**
 * @return breadcrumbs
 */
if(!function_exists('orion_get_breadcrumbs')) {
	function orion_get_breadcrumbs($heading_type) {
		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}		
		$orion_breadcrumbs_option = 'crumbs-onoff-'.$heading_type;

		if(!array_key_exists( $orion_breadcrumbs_option , $orion_options )) {
			return( get_template_part( 'templates/heading/content', 'breadcrumbs' ) );
		} else if (isset($orion_options[$orion_breadcrumbs_option]) && $orion_options[$orion_breadcrumbs_option] == '1') {
			return( get_template_part( 'templates/heading/content', 'breadcrumbs' ) );
		} 
	}
}

if(!function_exists('orion_hextorgba')) {
	function orion_hextorgba($hex, $alpha = false) {
	   $hex = str_replace('#', '', $hex);
	   if ( strlen($hex) == 6 ) {
	      $rgb['r'] = hexdec(substr($hex, 0, 2));
	      $rgb['g'] = hexdec(substr($hex, 2, 2));
	      $rgb['b'] = hexdec(substr($hex, 4, 2));
	   }
	   else if ( strlen($hex) == 3 ) {
	      $rgb['r'] = hexdec(str_repeat(substr($hex, 0, 1), 2));
	      $rgb['g'] = hexdec(str_repeat(substr($hex, 1, 1), 2));
	      $rgb['b'] = hexdec(str_repeat(substr($hex, 2, 1), 2));
	   }
	   else {
	      $rgb['r'] = '0';
	      $rgb['g'] = '0';
	      $rgb['b'] = '0';
	   }
	   if ( $alpha ) {
	      $rgb['a'] = $alpha;
	   } else {
	   	 $rgb['a'] = '1';
	   }
	   return 'rgba(' . $rgb['r'] .','. $rgb['g'] .','. $rgb['b'].','. $rgb['a']. ')';
	}
}

/**
 * darken / lighten
 **/
if(!function_exists('orion_adjustBrightness')) {
	function orion_adjustBrightness($hex, $steps) {
	    // Steps should be between -255 and 255. Negative = darker, positive = lighter
	    $steps = max(-255, min(255, $steps));

	    // Normalize into a six character long hex string
	    $hex = str_replace('#', '', $hex);
	    if (strlen($hex) == 3) {
	        $hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
	    }

	    // Split into three parts: R, G and B
	    $color_parts = str_split($hex, 2);
	    $return = '#';

	    foreach ($color_parts as $color) {
	        $color   = hexdec($color); // Convert to decimal
	        $color   = max(0,min(255,$color + $steps)); // Adjust color
	        $return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT); // Make two char hex code
	    }

	    return $return;
	}
}

if (!function_exists('orion_isColorLight')) {
	function orion_isColorLight($hex) {
	   $hex       = str_replace('#', '', $hex);
	   $r         = (hexdec(substr($hex, 0, 2)) / 255);
	   $g         = (hexdec(substr($hex, 2, 2)) / 255);
	   $b         = (hexdec(substr($hex, 4, 2)) / 255);
	   $lightness = round((((max($r, $g, $b) + min($r, $g, $b)) / 2) * 100));
	   return ($lightness >= 50 ? true : false);
	}
}	
/**
 * 
 * add search to the menu
 * @return search icon markup in main menu.
 *
 * used in templates/header/header-*
 */

if (!function_exists('orion_nav_wrap')) {
	function orion_nav_wrap() {
		$last_tab_html = '';
		$search_icon = false;
		$woocart = false;
		$cta_button = false;
		$search_HTML_class = '';
		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}
		
		if (isset($orion_options['last_tab_size'])) {
			$last_tab_size = $orion_options['last_tab_size'];
		} else {
			$last_tab_size = 's48';
		}

		switch ($last_tab_size) {
		    case "s48":
		    	$last_tab_class = 'style-medium';
		    	break;
			case "s36":
				$last_tab_class = 'style-small';
				break;
			case "s60":
				$last_tab_class = 'style-large';
				break;				
			default:
				$last_tab_class = 'style-medium';
				break;
		}

		if (isset($orion_options['search_icon']) && $orion_options['search_icon'] != '0') {
			$search_icon = $orion_options['search_icon'];
		    $search_link = '<li class="menu-item search simple search-toggle">';
		    $search_link .= '<div class="to-x">';
		    $search_link .= '<div class="search-box">';
			$search_link .= '<div class="circle top"></div>';
			$search_link .= '<div class="circle bottom"></div>';
			$search_link .= '<div class="handle"></div>';
			$search_link .= '</div>';
		    $search_link .= '</div>';
		    $search_link .= '</li>';
		    $search_icon = true;			
		} else {
			$search_link = "";
		}

		if( class_exists( 'WooCommerce' ) && isset($orion_options['woo_cart']) && $orion_options['woo_cart']!='0') {
			$orion_cart_class = '';
			if ($orion_options['woo_cart']!='0' && $orion_options['woo_cart']!='1') {
				$orion_cart_class = ' ' . $orion_options['woo_cart'];
			}
			ob_start();
			woocommerce_mini_cart();
			$woo_cart = '<li class="woocart'.$orion_cart_class.'" data-items="' . WC()->cart->get_cart_contents_count(). '">';
			$woo_cart .= ob_get_contents();
			$woo_cart .= '</li>';
			ob_end_clean();	
			$woocart = true;
		} else {
			$woo_cart = '';
		}

		$menu_btn = orion_get_menu_button();
		if(!is_null($menu_btn) && strlen($menu_btn) > 10) {
			$cta_button = true;
		}
		$mobile_menu_toggle = '';
		if (isset($orion_options['search_icon']) && ($orion_options['search_icon'] == '1' || $orion_options['search_icon'] == 'hidden-md-lg')) {		
			$mobile_menu_toggle = '<div class="search-form hidden-md hidden-lg">';
		    $mobile_menu_toggle .= get_search_form($echo = false);
		    $mobile_menu_toggle .= '</div>';
		}	    

		$last_tab_html = "<li class='last-tab " . $last_tab_class . "'>";
		$last_tab_html .= $mobile_menu_toggle;
		$last_tab_html .= '<div class="last-tab-wrap"> <ul>';
		$last_tab_html .=  $search_link . $woo_cart . $menu_btn; 
		$last_tab_html .= '</ul></div>';
		$last_tab_html .= '</li>';

	    if ($search_icon == false && $cta_button == false && $woocart == false) {
	    	$last_tab_html = '';
	    }

		$wrap  = '<ul id="%1$s" class="%2$s">';
	    $wrap .= '%3$s';
	    $wrap .= $last_tab_html;
	    $wrap .= '</ul>';

		return $wrap;
	}
}
 
/**
 * @return passpartout
 */
if(!function_exists('orion_get_passepartout')) {
	function orion_get_passepartout() {
		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}		
		$dentalia_passepartout_data = "";
		if (!isset($orion_options['passepartout'])) {
			return;
		}
		$is_fullwidth = $orion_options['boxed_fullwidth']; 
		if($is_fullwidth != 1) {
			return;	
		}
		if ($orion_options['passepartout'] != '1') {
			return;
		//passpartue data exists
		} else {			
			/* passpart height */
			if ( $orion_options['passepartout_size']['height'] != '' ) {
				$passpartuet_height = $orion_options['passepartout_size']['height'];
			} else {
				$passpartuet_height = '24';
			}

			/* passpart width */
			if ( $orion_options['passepartout_size']['width'] != '' ) {
				$passpartuet_width = $orion_options['passepartout_size']['width'];
			} else {
				$passpartuet_width = '24';
			}

			/* passpart color */
			if ( $orion_options['passepartout_color'] != '' ) {
				$passepartout_color = $orion_options['passepartout_color'];
			} else {
				$passepartout_color = 'f8f8f8';
			}
			$dentalia_passepartout_data .= ' data-passepartoutheight='.$passpartuet_height;
			$dentalia_passepartout_data .= ' data-passepartoutwidth='.$passpartuet_width;
			$dentalia_passepartout_data .= ' data-passepartoutcolor='.$passepartout_color;
		}

		echo esc_attr($dentalia_passepartout_data);
	}
}

if(!function_exists('orion_get_sticky_logo')) {
	function orion_get_sticky_logo() {
		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}
		/* get logo alt text */
		if(isset($orion_options['text_logo']) && $orion_options['text_logo'] != ''){
			$logo_text = $orion_options['text_logo'];
		} else {
			$logo_text = get_bloginfo('name');
		}
		
		/* display sticky logo if there is one, else display normal logo */
		if(isset($orion_options['logo_upload_sticky']) && $orion_options['logo_upload_sticky'] != '' && $orion_options['logo_upload_sticky']['url'] != '') : ?>
		<?php $logo_sticky = $orion_options['logo_upload_sticky']['url'];
		?>
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( $logo_text );?>" class="logo logo-sticky">
				<img src="<?php echo esc_url($logo_sticky); ?>" alt="<?php echo esc_attr( $logo_text );?>" />
			</a>
		<?php else : ?>
			<?php orion_get_logo();?>
		<?php endif;
	}
}

if(!function_exists('orion_get_logo')) {
	function orion_get_logo() {
		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}
		$logo_light = false;
		$logo_dark = false;
		$logos = 0;

		if(isset($orion_options['text_logo']) && $orion_options['text_logo'] != ''){
			$logo_text = $orion_options['text_logo'];
		} else {
			$logo_text = get_bloginfo('name');
		}
		if( isset($orion_options['logo_upload_light']['url']) && $orion_options['logo_upload_light']['url'] != "" ) {
			$logo_light = $orion_options['logo_upload_light']['url'];
			$logo = $logo_light;
			$logos ++;
		} 
		if( isset($orion_options['logo_upload_dark']['url']) && $orion_options['logo_upload_dark']['url'] != "" ) {
			$logo_dark = $orion_options['logo_upload_dark']['url'];
			$logo = $logo_dark;
			$logos ++;
		}	
		if ($logos == 0) : ?>
			<a class="site-title logo" href="<?php echo esc_url( home_url( '/' ) ); ?>"><span class="h1"><?php echo wp_kses_post( $logo_text );?></span></a>

		<?php elseif ($logos == 1) : ?>

			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( $logo_text );?>" class="logo logo-default">
				<img src="<?php echo esc_url($logo); ?>" alt="<?php echo esc_attr( $logo_text );?>" />
			</a>

		<?php else : ?>

			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( $logo_text );?>" class="logo logo-light">
				<img src="<?php echo esc_url($logo_light); ?>" alt="<?php echo esc_attr( $logo_text );?>" />
			</a>
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( $logo_text );?>" class="logo logo-dark">
				<img src="<?php echo esc_url($logo_dark); ?>" alt="<?php echo esc_attr( $logo_text );?>" />
			</a>
		<?php endif; 		
	}
}
if(!function_exists('orion_get_navigation')) {
	// used for separator default colors
	function orion_get_navigation( $container_classes = array(), $menu_classes = array()) {
			
		// are there any special classes?
		$html_container_classes = 'main-nav-wrap';
		if (is_array ( $container_classes )) {
			$html_container_classes .= ' ' . implode(" ", $container_classes );
		}

		$html_menu_classes = 'nav-menu';
		if (is_array ( $menu_classes )) {
			$html_menu_classes .= ' ' . implode(" ", $menu_classes );
		}		

		// is megamenu on in theme options?
		if (has_nav_menu( 'primary' ) && orion_get_option('orion_megamenu', false) == true){
	 		wp_nav_menu( 
	 			array( 
		 			'theme_location' => 'primary', 
		 			'menu_class' => $html_menu_classes, 
		 			'container_class' => $html_container_classes, 
		 			'items_wrap' => orion_nav_wrap(),
		 			'walker'  => new OrionNavWalker() //use our custom walker
	 			) 
	 		);
		} else {
 			wp_nav_menu( 
 				array( 
		 			'theme_location' => 'primary', 
		 			'menu_class' => $html_menu_classes, 
		 			'container_class' => $html_container_classes, 
		 			'items_wrap' => orion_nav_wrap(),
		 		) 
 			); 
		}
	}
}

if(!function_exists('orion_site_content_bg')) {
	// used for separator default colors
	function orion_site_content_bg() {
		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}
		if(isset($orion_options['site_background_color']) && $orion_options['site_background_color'] != ''){
			$content_bg_color = $orion_options['site_background_color'];
		} else {
			$content_bg_color = '#fff';
		}
		$data_att = ' data-site-content-bg =' . $content_bg_color;
		echo esc_attr($data_att);
	}
}


if(!function_exists('orion_is_boxed')) {
	function orion_is_boxed($start_end) {
		
		$orion_options = get_option('dentalia', orion_get_orion_defaults());
		$is_fullwidth = $orion_options['boxed_fullwidth']; 

		if($is_fullwidth === '0') {
			if ($start_end == 'start') : ?>
				<div class="boxed-container primary-content">
			<?php else : ?>
				</div> <!-- boxed -->
			<?php endif;
		}
	}
}

if(!function_exists('orion_heading_classes')) {
	/**
	 * adds page heading HTML classes
	 * @return string (HTML classes)
	 */
	function orion_heading_classes() {
		
		$heading_classes = ' ';
		$orion_options = get_option('dentalia', orion_get_orion_defaults());

		if ( is_single() || is_page() || (is_home() && is_front_page() == false)) {
			if (is_home() && is_front_page() == false) {
				$page_for_posts = get_option( 'page_for_posts' );
				$orion_wp_meta = get_post_meta( $page_for_posts );
			} else  {
				$orion_wp_meta = get_post_meta( get_the_ID() );
			}
			if (isset($orion_wp_meta['_dentalia_heading_text_color']) && $orion_wp_meta['_dentalia_heading_text_color'][0] != 'text-default') {
				$heading_classes .= $orion_wp_meta['_dentalia_heading_text_color'][0];
			}
			if (isset($orion_wp_meta['_dentalia_orion_overlay']) && $orion_wp_meta['_dentalia_orion_overlay'][0] != 'default') {
				if ($orion_wp_meta['_dentalia_orion_overlay'][0] != 'none') {
					$heading_classes .= ' ' . $orion_wp_meta['_dentalia_orion_overlay'][0];
				}
				
			} else if (isset($orion_options['default_overlay']) && $orion_options['default_overlay'] != '' && $orion_options['default_overlay'] != 'none') {
				$heading_classes .= ' ' . $orion_options['default_overlay'];
			}
			if (isset($orion_wp_meta['_dentalia_orion_parallax']) && $orion_wp_meta['_dentalia_orion_parallax'][0] != 'default') {
				$heading_classes .= ' ' . $orion_wp_meta['_dentalia_orion_parallax'][0];
				if($orion_wp_meta['_dentalia_orion_parallax'][0] != 'fixed') {
					$heading_classes .= ' orion-parallax';
				}
			}
			if (isset($orion_wp_meta['_dentalia_heading_bg_img_repeat']) && $orion_wp_meta['_dentalia_heading_bg_img_repeat'][0] != 'default') {
				$heading_classes .= ' ' .$orion_wp_meta['_dentalia_heading_bg_img_repeat'][0];
			}
			if (isset($orion_wp_meta['_dentalia_heading_bg_img_sizing']) && $orion_wp_meta['_dentalia_heading_bg_img_sizing'][0] != 'default') {
				$heading_classes .= ' ' .$orion_wp_meta['_dentalia_heading_bg_img_sizing'][0];
			}
			if (isset($orion_wp_meta['_dentalia_heading_bg_img_align']) && $orion_wp_meta['_dentalia_heading_bg_img_align'][0] != 'default') {
				$heading_classes .= ' ' .$orion_wp_meta['_dentalia_heading_bg_img_align'][0];
			}
		} else if (isset($orion_options['default_overlay']) && $orion_options['default_overlay'] != '' && $orion_options['default_overlay'] != 'none') {
			$heading_classes .= ' ' . $orion_options['default_overlay'];	
		}
		return $heading_classes;
	}
}

if(!function_exists('orion_heading_style')) {
	/**
	 * adds page heading HTML classes
	 * @return string (HTML classes)
	 */
	function orion_heading_style() {
		$heading_style = ' ';

		if ( is_single() || is_page() || (is_home() && is_front_page() == false)) {
			if (is_home() && is_front_page() == false) {
				$page_for_posts = get_option( 'page_for_posts' );
				$orion_wp_meta = get_post_meta( $page_for_posts );
			} else {
				$orion_wp_meta = get_post_meta( get_the_ID() );
			}
		} elseif (is_404()) {
			$orion_options = get_option('dentalia', orion_get_orion_defaults());
	
			if (isset($orion_options['page_404']) && $orion_options['page_404'] != '') {
				$orion_wp_meta = get_post_meta( $orion_options['page_404'] );
			} else {
				$heading_style = '';
			}
		}

		$heading_style = 'style="';
		if (isset($orion_wp_meta['_dentalia_heading_bg_image'])) {
			$heading_style .= 'background-image: url(' . $orion_wp_meta['_dentalia_heading_bg_image'][0] . ');';
		}
		if (isset($orion_wp_meta['_dentalia_top_padding'][0]) && $orion_wp_meta['_dentalia_top_padding'][0] != '') {
			$h_padding_top = preg_replace('/[^0-9]+/', '', $orion_wp_meta['_dentalia_top_padding'][0]);
			$heading_style .= ' padding-top:' . (int)$h_padding_top . 'px;';
		}
		if (isset($orion_wp_meta['_dentalia_bottom_padding'][0]) && $orion_wp_meta['_dentalia_bottom_padding'][0] != '') {
			$h_padding_bottom = preg_replace('/[^0-9]+/', '', $orion_wp_meta['_dentalia_bottom_padding'][0]);
			$heading_style .= ' padding-bottom:' . (int)$h_padding_bottom . 'px;';
		}	
		$heading_style .= '"';

		return $heading_style;
	}
}

if(!function_exists('orion_get_class_cb')) {
	/**
	 * Echo any class (if needed) from a checkbox options or a switch
	 * @param  string $the_orion_option  redux option name
	 * @param  string $def_class_name 	 class to return if checked
	 * @param  string $alt_class_name  	 class to return if NOT checked
	 * @param  string $default  		 in case there is no option value saved echo def_class_name unless specified 'off'
	 * @return echo HTML class
	 */
	function orion_get_class_cb( $the_orion_option, $def_class_name, $alt_class_name="", $default="on" ) {
		$orion_options = get_option('dentalia', orion_get_orion_defaults());

		$html_class = "";

		if (isset($orion_options[$the_orion_option])) {
			if ($orion_options[$the_orion_option] == 1 || $orion_options[$the_orion_option] == 'on') {
				if ($def_class_name == "noclass") {
					$html_class = '';
				} else {
					$html_class .= $def_class_name;
				}					
			} else {
				if ($alt_class_name == "noclass") {
					$html_class = '';
				} else {
					$html_class .= $alt_class_name;
				}	
			}
		} else {
			// no option is found			
			$arg_num = func_num_args();
			switch ($arg_num) {
				case 4:
					if ($default != "noclass") {
						$html_class .= $default;
					}
					break;
			    case 2:
			    case 3:
						$html_class .= $def_class_name;
					break;
			}

		}
		// echo appropriate HTML class
		echo esc_attr($html_class);
	}
}

//function orion_option
if(!function_exists('orion_get_option')) {
	/**
	 * get HTML classes from theme options
	 * @param  string $the_orion_option 
	 * @param  bolean $echo 
	 * @param  string $default
	 * @return string
	 */
	function orion_get_option($the_orion_option, $echo = true, $default = false) {
		$html_class = "";
		//	if the option is NOT saved in the database
		$orion_options = get_option('dentalia', orion_get_orion_defaults());
		if ( !isset($orion_options[$the_orion_option]) || $orion_options[$the_orion_option] == "" ) {
			if ($default) {
				if ($echo) {
					echo esc_attr($default);		
				} else {
					return $default;
				}
			}		
		} else { 
			$html_class .= $orion_options[$the_orion_option];
		}

		if ($echo) {
			echo esc_attr($html_class);		
		} else {
			return $html_class;
		}
	}
}

if(!function_exists('orion_get_real_option')) {
	/**
	 * Same as orion_get_option, but requires redux options and ignores defaults.
	 * @param  string $the_orion_option 
	 * @param  bolean $echo 
	 * @param  string $default
	 * @return string
	 */
	function orion_get_real_option($the_orion_option, $echo = true, $default = false) {

		$html_class = "";
		//	if the option is NOT saved in the database
		$orion_options = get_option('dentalia');

		if ( !isset($orion_options[$the_orion_option]) || $orion_options[$the_orion_option] == "" ) {
			if ($default) {
				if ($echo) {
					echo esc_attr($default);		
				} else {
					return $default;
				}
			}		
		} else { 
			$html_class .= $orion_options[$the_orion_option];
		}

		if ($echo) {
			echo esc_attr($html_class);		
		} else {
			return $html_class;
		}
	}
}

//function orion_option
if(!function_exists('orion_get_theme_option_css')) {
	/**
	 * get options values from deep in theme option array, if is not set, return the backup option, else return default.
	 * Accepts arrays too. ie:
	 * 
	 * orion_get_theme_option_css(array('link_color','regular'), 'red', 'main_theme_color');
	 * or
	 * orion_get_theme_option_css(array('link_color','regular'), 'red', '')
	 *
	 * 1. checks for orion_options[link_color][regular], 
	 * 2. if there is no value, checks main_theme_color, 
	 * 3. if still none, echoes red
	 * 
	 * returns string 
	 */
	function orion_get_theme_option_css($theme_option_1, $default = false, $theme_option_2 = false) {

		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}		
		$css = "";

		/* check first theme option */
		$status = true;
		$new_orion_options = $orion_options;
		if (is_string($theme_option_1)) {
            if (isset($orion_options[$theme_option_1]) && $orion_options[$theme_option_1] != '') {
            	$new_orion_options = $orion_options[$theme_option_1]; 
            }
		} else {	
			foreach ( $theme_option_1 as $option ) {   
		        if($status) {
		            if (isset($new_orion_options[$option]) && $new_orion_options[$option] != '') {
		                $new_orion_options = $new_orion_options[$option]; 
		            } else {
		                $status = false;
		            }
		        }
	   		}
		}	   		
   		if (is_string($new_orion_options)) {
   			return($new_orion_options);
   		/* check second theme option */
   		} else {
   			$status = true;
   			$new_orion_options = $orion_options;
   			if ($theme_option_2 == false) {
   				//just move on
   			} else if (is_string($theme_option_2)) {
	            if (isset($orion_options[$theme_option_2]) && $orion_options[$theme_option_2] != '') {
	            	$new_orion_options = $orion_options[$theme_option_2]; 
	            }
			} else {		
				foreach ( $theme_option_2 as $option ) {   
			        if($status) {
			            if (isset($new_orion_options[$option]) && $new_orion_options[$option] != '') {
			                $new_orion_options = $new_orion_options[$option];
			            } else {
			                $status = false;
			            }
			        }
		   		}
		   	}	 		
	  		if (is_string($new_orion_options)) {
	   			return($new_orion_options);
	   		/* if everything fails, return default */
			} else {
				return($default);
			}
		}	
	} 
}
//function orion_option
//
if(!function_exists('orion_post_meta_array')) {
	function orion_post_meta_array() {
		$orion_options = get_option('dentalia', orion_get_orion_defaults());	
		if (isset($orion_options['postmeta_settings'])) {
			$meta = $orion_options['postmeta_settings'];
			if($meta == 0){
				$meta = array();
			}
		} else {
			$meta = array( 1 => '1', 2 => '1', 3 => '1', 4 => '');
		}
		return $meta;
	}
}

if(!function_exists('orion_option_css')) {
	/**
	 * echoes options values from deep in theme option array, if is not set, return the backup option, else return default.
	 * Accepts arrays too. ie:
	 * 
	 * orion_option_css(array('link_color','regular'),'main_theme_color', 'red');
	 *
	 * 1. checks for orion_options[link_color][regular], 
	 * 2. if there is no value, checks main_theme_color, 
	 * 3. if still none, echoes red
	 * 
	 * echo string
	 */
	

	function orion_option_css($theme_option_1, $default = false, $theme_option_2 = false) {
		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}		
		$css = "";

		/* check first theme option */
		$status = true;
		$new_orion_options = $orion_options;
		if (is_string($theme_option_1)) {
            if (isset($orion_options[$theme_option_1]) && $orion_options[$theme_option_1] != '') {
            	$new_orion_options = $orion_options[$theme_option_1]; 
            } else {
            	$status = false;
            }
		} else {
			foreach ( $theme_option_1 as $option ) {   
		        if($status) {
		            if (isset($new_orion_options[$option]) && $new_orion_options[$option] != '') {
		                $new_orion_options = $new_orion_options[$option]; 
		            } else {
		                $status = false;
		            }
		        }
	   		}
		}	   		
   		if (is_string($new_orion_options) && is_string($new_orion_options)!='') {
   			echo esc_attr($new_orion_options);
   		/* check second theme option */
   		} else {

   			$status = true;
   			$new_orion_options = $orion_options;
   			if ($theme_option_2 == false) {
   				//just move on
   			} else if (is_string($theme_option_2)) {
	            if (isset($orion_options[$theme_option_2]) && $orion_options[$theme_option_2] != '') {
	            	$new_orion_options = $orion_options[$theme_option_2]; 
	            }
			} else {		
				foreach ( $theme_option_2 as $option ) {   
			        if($status) {
			            if (isset($new_orion_options[$option]) && $new_orion_options[$option] != '') {
			                $new_orion_options = $new_orion_options[$option];
			            } else {
			                $status = false;
			            }
			        }
		   		}
		   	}	 		
	  		if (is_string($new_orion_options) && is_string($new_orion_options)!=NULL) {
	   			echo esc_attr($new_orion_options);
	   		/* if everything fails, return default */
			} else {
				echo esc_attr($default);
			}
		}	
	} 
}
// dump Redux theme options
/**
 * Function used for debugging and developpment purpuses
 * @param  [type]  $option   [description]
 * @param  boolean $dontexit [description]
 * @return [type]            [description]
 */
function orion_dump_option($option, $dontexit = false){
	global $orion_options;	 
	$the_option = $orion_options[$option];

	var_dump($the_option);
	if ($dontexit) {
		Exit;
	}
}

/* Page heading */
if(!function_exists('orion_get_page_heading')) {

	function orion_get_page_heading() {

		// get meta
		if (is_404() ) {
			$orion_options = get_option('dentalia', orion_get_orion_defaults());
			if (isset($orion_options['page_404']) && $orion_options['page_404'] != '') {
				$orion_wp_meta = get_post_meta( $orion_options['page_404'] );
			}	
		} else if (function_exists('is_shop') && is_shop()) {
			$woo_shop_id = wc_get_page_id( 'shop' );
			$orion_wp_meta = get_post_meta( $woo_shop_id );			
		
		} else if (is_home() && is_front_page() == false) {
			$page_for_posts = get_option( 'page_for_posts' );
			$orion_wp_meta = get_post_meta( $page_for_posts );
		} else if (is_archive() ) {
			$orion_wp_meta = array();
			$orion_wp_meta['_dentalia_hide_heading'][0] = '';
		} else {
			$orion_wp_meta = get_post_meta( get_the_ID() );
		}
		// display heading
		if (isset($orion_wp_meta['_dentalia_hide_heading']) && ($orion_wp_meta['_dentalia_hide_heading'][0] == 'on')) {
			// return;
		} else {	

			if ( ( is_single() || is_page() || is_404() || (function_exists('is_shop') && is_shop())) && isset($orion_wp_meta['_dentalia_heading_type']) ) {
				$heading_layout_style = $orion_wp_meta['_dentalia_heading_type'][0];
				if ($heading_layout_style == 'default') {
					$heading_layout_style = orion_get_option('post_heading_type', false);
				}
				get_template_part( 'templates/heading/content-heading', $heading_layout_style );
			} else {
				get_template_part( 'templates/heading/content-heading', orion_get_option('post_heading_type', false) );
			}
		}
		/* display banner area */
		if (isset($orion_wp_meta['_dentalia_banner_area_static_block']) && ($orion_wp_meta['_dentalia_banner_area_static_block'][0] != 'none')) {
			$static_block = ($orion_wp_meta['_dentalia_banner_area_static_block']);
			

			if ( is_single() || is_page() || is_404() || (function_exists('is_shop') && is_shop()) || (is_home() && is_front_page() == false)) {
				get_template_part( 'templates/heading/content-heading', 'staticblock' );
			}
		}
	}
}

/* .site-main paddings */
if(!function_exists('get_orion_page_padding')) { 
	function get_orion_page_padding( $id=false ) {
		if ($id == false ) {
			$orion_wp_meta = get_post_meta( get_the_ID() );
		} else {
			$orion_wp_meta = get_post_meta( $id );
		}
		$html_classes = '';
 		if (isset($orion_wp_meta['_dentalia_remove_padding_top']) && ($orion_wp_meta['_dentalia_remove_padding_top'][0] == 'on')) {
			$html_classes .= ' notoppadding';
		}
		if (isset($orion_wp_meta['_dentalia_remove_padding_bottom']) && ($orion_wp_meta['_dentalia_remove_padding_bottom'][0] == 'on')) {
			$html_classes .= ' nobottompadding';
		}				
		return $html_classes;
	}
}

/*sidebars*/
if(!function_exists('orion_get_sidebars')) { 
	function orion_get_sidebars() {
		$num_of_sidebars = '0';
		$right_sidebar = "no_sidebar";
		$left_sidebar = 'no_sidebar';
		$ot_sidebars = array(
			'primary_class' => 'col-md-12', 
			'left_sidebar_class' => '', 
			'right_sidebar_class' =>'',
			'ot_left_sidebar_id' => '',
			'ot_right_sidebar_id' => ''		
		);

		if (is_single() && get_post_type() != 'product') {	
			$orion_wp_meta = get_post_meta( get_the_ID() );
			if (isset($orion_wp_meta['_dentalia_post_sidebar_select_left']) && ($orion_wp_meta['_dentalia_post_sidebar_select_left'][0] != 'no_sidebar')) {
				$ot_sidebars['ot_left_sidebar_id'] = $orion_wp_meta['_dentalia_post_sidebar_select_left'][0];

				if (is_active_sidebar($ot_sidebars['ot_left_sidebar_id'])) {
					$num_of_sidebars++;   
				} else {
					$ot_sidebars['ot_left_sidebar_id'] = '';
				}

			}		
			if (isset($orion_wp_meta['_dentalia_post_sidebar_select_right']) && ($orion_wp_meta['_dentalia_post_sidebar_select_right'][0] != 'no_sidebar')) {
				$ot_sidebars['ot_right_sidebar_id'] = $orion_wp_meta['_dentalia_post_sidebar_select_right'][0];
				
				if (is_active_sidebar($ot_sidebars['ot_right_sidebar_id'])) {
					$num_of_sidebars++;   
				} else {
					$ot_sidebars['ot_right_sidebar_id'] = '';
				}	  
			}

		} else if(is_page() || get_post_type() == 'product'){
			if( function_exists('is_shop') && is_shop() && get_option( 'woocommerce_shop_page_id' ) != '') {	
				$woo_shop_id = get_option( 'woocommerce_shop_page_id' ); 
 				$orion_wp_meta = get_post_meta( $woo_shop_id );
 			} else {
				$orion_wp_meta = get_post_meta( get_the_ID() );
			}
			if (isset($orion_wp_meta['_dentalia_page_sidebar_select_left']) && ($orion_wp_meta['_dentalia_page_sidebar_select_left'][0] != 'no_sidebar')) {
				$ot_sidebars['ot_left_sidebar_id'] = $orion_wp_meta['_dentalia_page_sidebar_select_left'][0];

				if (is_active_sidebar($ot_sidebars['ot_left_sidebar_id'])) {
					$num_of_sidebars++;   
				} else {
					$ot_sidebars['ot_left_sidebar_id'] = '';
				}
			  	
			}		
			if (isset($orion_wp_meta['_dentalia_page_sidebar_select_right']) && ($orion_wp_meta['_dentalia_page_sidebar_select_right'][0] != 'no_sidebar')) {
				$ot_sidebars['ot_right_sidebar_id'] = $orion_wp_meta['_dentalia_page_sidebar_select_right'][0];

				if (is_active_sidebar($ot_sidebars['ot_right_sidebar_id'])) {
					$num_of_sidebars++;   
				} else {
					$ot_sidebars['ot_right_sidebar_id'] = '';
				}				
			}

		} else if (is_archive() || is_search()) {
			global $orion_options;
			if(empty($orion_options)) {
				$orion_options = orion_get_orion_defaults();
			}		
			if (isset($orion_options['archive_blog_sidebar_left_defaults']) && ($orion_options['archive_blog_sidebar_left_defaults'] != "")) {
	           	$ot_sidebars['ot_left_sidebar_id'] = $orion_options['archive_blog_sidebar_left_defaults'];
				if (is_active_sidebar($ot_sidebars['ot_left_sidebar_id'])) {
					$num_of_sidebars++;   
				} else {
					$ot_sidebars['ot_left_sidebar_id'] = '';
				}   
	        } 
	     	if (isset($orion_options['archive_blog_sidebar_right_defaults']) && ($orion_options['archive_blog_sidebar_right_defaults'] != "")) {
	           	$ot_sidebars['ot_right_sidebar_id'] = $orion_options['archive_blog_sidebar_right_defaults'];
				if (is_active_sidebar($ot_sidebars['ot_right_sidebar_id'])) {
					$num_of_sidebars++;   
				} else {
					$ot_sidebars['ot_right_sidebar_id'] = '';
				}	
	        }
		} else if ( is_home() && is_front_page() ) { 
			global $orion_options;
			if(empty($orion_options)) {
				$orion_options = orion_get_orion_defaults();
			}
			if (isset($orion_options['archive_blog_sidebar_left_defaults']) && ($orion_options['archive_blog_sidebar_left_defaults'] != "")) {
	          	$ot_sidebars['ot_left_sidebar_id'] = $orion_options['archive_blog_sidebar_left_defaults'];
				
				if (is_active_sidebar($ot_sidebars['ot_left_sidebar_id'])) {
					$num_of_sidebars++;   
				} else {
					$ot_sidebars['ot_left_sidebar_id'] = '';
				} 
	        } 
	     	if (isset($orion_options['archive_blog_sidebar_right_defaults']) && ($orion_options['archive_blog_sidebar_right_defaults'] != "")) {
	           	$ot_sidebars['ot_right_sidebar_id'] = $orion_options['archive_blog_sidebar_right_defaults'];
				
				if (is_active_sidebar($ot_sidebars['ot_right_sidebar_id'])) {
					$num_of_sidebars++;   
				} else {
					$ot_sidebars['ot_right_sidebar_id'] = '';
				}	
	        }
		} else if (is_home() || is_front_page() == false) {     
			$orion_wp_meta = get_post_meta( get_option( 'page_for_posts' ) );

			if (isset($orion_wp_meta['_dentalia_page_sidebar_select_left']) && ($orion_wp_meta['_dentalia_page_sidebar_select_left'][0] != 'no_sidebar')) {
				$ot_sidebars['ot_left_sidebar_id'] = $orion_wp_meta['_dentalia_page_sidebar_select_left'][0];
				if (is_active_sidebar($ot_sidebars['ot_left_sidebar_id'])) {
					$num_of_sidebars++;   
				} else {
					$ot_sidebars['ot_left_sidebar_id'] = '';
				}   
			}		
			if (isset($orion_wp_meta['_dentalia_page_sidebar_select_right']) && ($orion_wp_meta['_dentalia_page_sidebar_select_right'][0] != 'no_sidebar')) {
				$ot_sidebars['ot_right_sidebar_id'] = $orion_wp_meta['_dentalia_page_sidebar_select_right'][0];
				
				if (is_active_sidebar($ot_sidebars['ot_right_sidebar_id'])) {
					$num_of_sidebars++;   
				} else {
					$ot_sidebars['ot_right_sidebar_id'] = '';
				}	 
			}

		} else {
			$num_of_sidebars = '0';
		}

		switch ($num_of_sidebars) {
			case '0' :
				$ot_sidebars['primary_class'] = " col-md-12";
				break;

			case '1' :
				$ot_sidebars['primary_class']=" col-md-8";
				if($ot_sidebars['ot_left_sidebar_id'] != '' ){
				  	$ot_sidebars['left_sidebar_class'] = ' col-md-4 col-md-pull-8';
				  	$ot_sidebars['primary_class'] .= ' col-md-push-4';
				}
				if($ot_sidebars['ot_right_sidebar_id'] != '' ){
					$ot_sidebars['right_sidebar_class'] = " col-md-4";	
				}
				break;

			case '2' :
			    $ot_sidebars['primary_class'] = " col-md-6 col-md-push-3";
			    $ot_sidebars['left_sidebar_class'] = " col-md-3 col-md-pull-6";
			    $ot_sidebars['right_sidebar_class'] = " col-md-3";
				break;

			default:
				
				$ot_sidebars['primary_class'] = " col-md-12";			
				break;
		}

		// Developers: 
		// use orion_filter_sidebars to extend sidebar functionality		
		return apply_filters( 'orion_filter_sidebars', $ot_sidebars );
	}
}
if(!function_exists('orion_display_prefooter')) { 
	function orion_display_prefooter() {

		$should_display = false;
		if (orion_get_option('prefooter_switch', false) == 1) {
			$should_display = true;
		}	
		if(is_page() || is_single() || (is_home() && is_front_page() == false) || (function_exists('is_shop') && is_shop()) ){		
			if (is_home() && is_front_page() == false) {
				$page_for_posts = get_option( 'page_for_posts' );
				$orion_wp_meta = get_post_meta( $page_for_posts );
			} else {
				$orion_wp_meta = get_post_meta( get_the_ID() );
			}
			if (function_exists('is_shop') && is_shop()) {
				$woo_shop_id = get_option( 'woocommerce_shop_page_id' ); 	
				$orion_wp_meta = get_post_meta( $woo_shop_id );

			}
			if ( isset($orion_wp_meta['_dentalia_hide_prefooter']) && ($orion_wp_meta['_dentalia_hide_prefooter'] == true) ) {	
				$should_display = false;
			}
		}

		return $should_display;
	}
}

/* excerpt length */
function orion_excerpt_length($limit) {
	$excerpt = get_the_excerpt();
	$excerpt = preg_replace('/(<script[^>]*>.+?<\/script>|<style[^>]*>.+?<\/style>)/s', '', $excerpt);
	$excerpt = strip_shortcodes( $excerpt );
	$excerpt = strip_tags($excerpt);
	$excerpt = str_replace(']]>', ']]&gt;', $excerpt);
    $excerpt = wp_trim_words(get_the_excerpt(), $limit);
    return $excerpt;
}

/* Comments */
if(!function_exists('orion_comments')) {
	function orion_comments($comment, $args, $depth) {

	    if ( 'div' === $args['style'] ) {
	        $tag       = 'div';
	        $add_below = 'comment';
	    } else {
	        $tag       = 'li';
	        $add_below = 'div-comment';
	    }
	    ?>
	    <<?php echo esc_attr($tag) ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
	    <?php if ( 'div' != $args['style'] ) : ?>
	        <div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	    <?php endif; ?>
	    <div class="comment-author vcard">
	        <?php if ( $args['avatar_size'] != 0 ) echo get_avatar( $comment, $args['avatar_size'] ); ?>
	        <?php echo wp_kses_post( sprintf( __( '<cite class="fn"><h6 class="comment-author-name">%s</h6></cite>', 'dentalia' ), get_comment_author_link() )); ?>
	    </div>
	    <?php if ( $comment->comment_approved == '0' ) : ?>
	         <em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'dentalia' ); ?></em>
	          <br />
	    <?php endif; ?>
	    <div class="comment-content">
	    	<?php comment_text(); ?>
	    </div>
	    <div class="comment-meta commentmetadata meta-data"><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>">
	        <?php
	        /* translators: 1: date, 2: time */
	        echo wp_kses_post(sprintf( __('%1$s at %2$s', 'dentalia'), get_comment_date(),  get_comment_time() )); ?></a><?php edit_comment_link( esc_html__( '(Edit)', 'dentalia' ), '  ', '' );
	        ?>
	    </div>

	    <div class="reply">
	        <?php comment_reply_link( array_merge( $args, array( 'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'], 'reply_text' => wp_kses_post(__( '<span class="font-3">Reply <i class="orionicon orionicon-mail-reply primary-color"></i></span>', 'dentalia' ) ) ) )); ?>
	    </div>
	    <?php if ( 'div' != $args['style'] ) : ?>
	    </div>
	    <?php endif; ?>
	    <?php
	}
}

/* Page title */
if(!function_exists('orion_page_title')) {
    function orion_page_title() {
        if(is_home() && is_front_page()) {
        	echo bloginfo ( 'description' );
        } else if( is_home() && !is_front_page()) {
	    	 echo get_the_title(get_option('page_for_posts'));;
        } else if( is_day() ) {
            echo esc_html__('Daily Archives', 'dentalia') . ': ' . get_the_date();
        } else if( is_month() ) {
            echo esc_html__('Monthly Archives', 'dentalia') . ': ' . get_the_time('F');
        } else if( is_year() ) {
            echo esc_html__('Yearly Archives', 'dentalia') . ': ' . get_the_time('Y');
        } else if( is_search() ) {
            echo esc_html__('Search results', 'dentalia');
        } else if( is_tag() ) {
            echo single_tag_title('', false);
        } else if( is_category() ) {
            echo single_cat_title('', false);
        } else if( is_tax() ) {
        	$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) ); 
        	echo esc_html($term->name);
        } else if( function_exists('is_shop') && is_shop() ) {
            echo get_the_title(get_option( 'woocommerce_shop_page_id' ));
        } else if( is_404() ) {
            echo esc_html__('Page not found', 'dentalia');
        } else if( is_author() ) {
            echo esc_html__('Articles posted by', 'dentalia') . ' ' . get_the_author();
		} else if(is_post_type_archive('team-member')) {
			echo esc_html__('The Team', 'dentalia');
	    } else {
            echo get_the_title();
        }
    }
}

if(!function_exists('orion_custom_styles')) {
	/**
	 * Generate custom styles
	 * @return custom css
	 */
	function orion_custom_styles() {
	    if ( file_exists( get_template_directory() . '/framework/css/custom-styles.php' ) ) {
	        require_once get_template_directory() . '/framework/css/custom-styles.php';
	    }
	}
}

if(!function_exists('orion_addhttp')) {
	function orion_addhttp($url) {
	    if (!preg_match("~^(?:f|ht)tps?://~i", $url) && !preg_match('/#/', $url) ) {
	        $url = "http://" . $url;
	    }
	    return $url;
	}
}

if(!function_exists('orion_removehttp')){
	function orion_removehttp($url) {
		$disallowed = array('http://', 'https://');
		foreach($disallowed as $d) {
			if(strpos($url, $d) === 0) {
			 	return str_replace($d, '', $url);
			}
   		}
   		return $url;
	}
}


if(!function_exists('orion_get_gallery_attachments')) {
	function orion_get_gallery_attachments(){
		global $post;
		
		$post_content = $post->post_content;
		preg_match('/\[gallery.*ids=.(.*).\]/', $post_content, $ids);

		if (!empty($ids)) {
			$images_id = explode(",", $ids[1]);
			return $images_id;
		}
	}
}

/**
 * returns blog type
 * @return blog type
 */
if(!function_exists('orion_get_blog_type')) {
	function orion_get_blog_type () {
		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}		
		if (array_key_exists('blog_layout', $orion_options)) {
			return $orion_options['blog_layout'];
		} else {
			return 'classic';
		}
	}
}

if(!function_exists('orion_paging_nav')) {
	/**
	 * create blog pagination
	 * @return pagination
	 */
	function orion_paging_nav() {
	  // Don't print empty markup if there's only one page.
	  if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
	    return;
	  }

	  $paged        = get_query_var( 'paged' ) ? (int) get_query_var( 'paged' )  : 1;
	  $pagenum_link = html_entity_decode( get_pagenum_link() );
	  $query_args   = array();
	  $url_parts    = explode( '?', $pagenum_link );

	  if ( isset( $url_parts[1] ) ) {
	    wp_parse_str( $url_parts[1], $query_args );
	  }

	  $pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
	  $pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

	  $format  = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
	  $format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';

	  // Set up paginated links.
	  $links = paginate_links( array(
	    'base'     => $pagenum_link,
	    'format'   => $format,
	    'total'    => $GLOBALS['wp_query']->max_num_pages,
	    'current'  => $paged,
	    'mid_size' => 3,
	    'add_args' => array_map( 'urlencode', $query_args ),
	    'prev_text' => esc_html__( '&larr;', 'dentalia' ),
	    'next_text' => esc_html__( '&rarr;', 'dentalia' ),
	    'type'      => 'list',
	  ) );

	  if ( $links ) : ?>
	  <nav class="navigation paging-navigation clearfix">
	    <h3 class="screen-reader-text"><?php _e( 'Posts navigation', 'dentalia' ); ?></h3>
	      <?php echo wp_kses_post($links);?> 
	  </nav><!-- .navigation -->
	  <?php
	  endif;
	}
}

if(!function_exists('orion_header_mobile_nav')) {
	function orion_header_mobile_nav() {
		;?>
		<div class="hidden-lg hidden-md text-center burger-container">
			<div class="to-x">

				<?php 
				/* Add a Call icon */
				$phone_number = orion_get_option('mobile_navigation_call_us_icon', '');
				if (isset($phone_number) && $phone_number!= '') :?>
					<?php $rel_phone_number = preg_replace('/[^\d+-]+/', '', $phone_number);?>
					<a href="tel:<?php echo esc_attr($rel_phone_number);?>" class="mobile-call-btn" aria-label="<?php echo esc_attr__('Call', 'dentalia');?>">
						<span class="orionicon orionicon-icon_phone"></span>
					</a>
				<?php endif;?>
				<div class="hamburger-box">
					<div class="bun top"></div>
					<div class="meat"></div>
					<div class="bun bottom"></div>
				</div>
				<?php /* woo cart button */
				$woo_cart = orion_get_option('woo_cart', false);
				
				if(class_exists( 'WooCommerce' ) && isset($woo_cart) && $woo_cart!='0') : ?>
					<?php 
						$woocart_class = '';
						if ($woo_cart!='0' && $woo_cart!='1'){
							$woocart_class .= ' ' . $woo_cart;
						}
						$woo_cart_mobile_text_color = orion_get_option('woo_cart_mobile_text_color', false, 'auto');
						if($woo_cart_mobile_text_color != 'auto'){
							$woocart_class .= ' mobile-cart-' . $woo_cart_mobile_text_color;
						}
					?>
					<div class="woocart<?php echo esc_attr($woocart_class);?>" data-items="<?php echo WC()->cart->get_cart_contents_count(); ?>">
						<?php woocommerce_mini_cart();?>
					</div>			
				<?php endif;?>
			</div>
		</div>	
		<?php
	}
}
/************************************* O.o *************************************/
/*                             FILTER FUNCTIONS                           	   */ 
/*******************************************************************************/

/* back to top button */
if(!function_exists('orion_back_to_top')) {
	function orion_back_to_top() {
		if (orion_get_theme_option_css('back_to_top', '0') == true)  :?>
	    	<a class="back-to-top primary-color-bg hideit" href="#" aria-label="<?php echo esc_attr('Back to top');?>"></a>
		<?php endif; 
	}
}	
add_action( 'wp_footer', 'orion_back_to_top' );


/**
 * Filter the excerpt "read more" string.
 *
 * @param string $more "Read more" excerpt string.
 * @return string modified "read more" excerpt string.
 */
if(!function_exists('orion_excerpt_more')) {
	function orion_excerpt_more( $more ) {
	    return '';
	}
}		
add_filter( 'excerpt_more', 'orion_excerpt_more' );

/** 
* Vertical menu toggle
* @return "vertical-menu" if vertical menu is turned on in theme options.
*/
if(!function_exists('orion_has_vertical_menu')) {
	function orion_has_vertical_menu() {
		global $orion_options;
		$orion_headertype = 'classic';
		if (isset($orion_options["orion_header_type"])) {
			$orion_headertype = $orion_options["orion_header_type"];	
		}
		if ($orion_headertype == 'vertical') {	
			return('vertical-menu');
		}
	}
}
if(!function_exists('orion_body_boxed_class')) {
	function orion_body_boxed_class() {
		$orion_options = get_option('dentalia', orion_get_orion_defaults());
		if ($orion_options['boxed_fullwidth'] === '0') {	
			return('boxed');
		}
	}
}

if(!function_exists('orion_one_page')) {
	function orion_one_page() {
		$orion_options = get_option('dentalia', array());
		 if (array_key_exists( 'one_page', $orion_options )) {
			if ($orion_options['one_page'] === '1') {	
				return('one-page');
			}
		 }
	}
}

/**
* add custom HTML classes to the <body> element.
* @param  $classes 
* @return <body> HTML classes 
*/
if(!function_exists('orion_body_classes')) {
	function orion_body_classes( $classes ) {	
		array_push( $classes, orion_has_vertical_menu());
		array_push( $classes, orion_body_boxed_class());
		array_push( $classes, orion_one_page());
		// push additional classes here, if needed...
	return $classes;}
}
add_filter( 'body_class', 'orion_body_classes' );

/* tag cloud */
if(!function_exists('orion_tag_cloud_args')) {
	function orion_tag_cloud_args( $args ) {
		$args['largest'] = 15;
		$args['smallest'] = 11;
		$args['unit'] = 'px';
		return $args;
	}
}
add_filter( 'widget_tag_cloud_args', 'orion_tag_cloud_args' );


/* Product tag cloud */
if(!function_exists('orion_product_tag_cloud_args')) {
	function orion_product_tag_cloud_args( $args ) {
		$args['largest'] = 11;
		$args['smallest'] = 11;
		$args['unit'] = 'px';
		return $args;
	}
}
add_filter( 'woocommerce_product_tag_cloud_widget_args', 'orion_product_tag_cloud_args' ); //woocommerce

/**
 * fallback for wp_nav_menu. Instead of not showing anyhing if there is no primary menu, fallback to wp_page_menu and adjust the markup.
 * @param  page_markup (default pagemenu markup)
 * @return markup adjusted for styling
 */
if(!function_exists('orion_page_menu')) {
	function orion_page_menu ($page_markup) {
	    $toreplace = 'nav-menu';
	    $new_markup = str_replace($toreplace, 'main-nav-wrap no-primary-nav', $page_markup);
	    $new_markup = preg_replace('<ul>', 'ul class="nav-menu float-right"', $new_markup, 1);
	    $new_markup = preg_replace('<page_item>', 'page_item menu-item', $new_markup);
	    $new_markup = preg_replace('<children>', 'sub-menu', $new_markup);
	    $new_markup = preg_replace('<menu-item_has_sub-menu>', 'menu-item-has-children', $new_markup);
	return $new_markup; }
}
add_filter('wp_page_menu', 'orion_page_menu');

/* menu button */
function orion_get_menu_button() {
	$button_text = $button_link = '';
	$display_button = false;

	$orion_options = get_option('dentalia', orion_get_orion_defaults());

	if (isset($orion_options['last_tab_size'])) {
		$last_tab_size = $orion_options['last_tab_size'];
	} else {
		$last_tab_size = 's48';
	}
	switch ($last_tab_size) {
	    case "s48":
	    	$btn_class = 'btn-md';
	    	break;
		case "s36":
			$btn_class = 'btn-sm';
			break;
		case "s60":
			$btn_class = 'btn-lg';
			break;				
		default:	
			$btn_class = 'btn-md';
			break;
	}
	if (isset($orion_options['header_button_rounding']) && $orion_options['header_button_rounding'] != '') {
		$btn_class .= ' ' . $orion_options['header_button_rounding'];
	}
	if (isset($orion_options['display_header_button'])) {
		$display_button = $orion_options['display_header_button'];
	}
	if (isset($orion_options['button_text'])) {
		$button_text = $orion_options['button_text'];
	}
	if (isset($orion_options['button_link_url'])) {
		$button_link = $orion_options['button_link_url'];
	}
	$button_atts = '';
	if (isset($orion_options['header_button_new_tab']) && $orion_options['header_button_new_tab'] == '1') {
		$button_atts = ' rel="noreferrer noopener" target="_blank"'; 
	}	

	$menu_btn_color = orion_get_option('header_button_color', false);

	if(is_page()) {
		$orion_wp_meta = get_post_meta( get_the_ID() );
		if (isset($orion_wp_meta['_dentalia_button_text']) && $orion_wp_meta['_dentalia_button_text']['0'] != '') {
			$button_text = $orion_wp_meta['_dentalia_button_text']['0'];
		}
		if (isset($orion_wp_meta['_dentalia_button_link']) && $orion_wp_meta['_dentalia_button_link']['0'] != '') {
			$button_link = $orion_wp_meta['_dentalia_button_link']['0'];
		}
		if(isset($orion_wp_meta['_dentalia_button_link']) && isset($orion_wp_meta['_dentalia_button_text']) && $orion_wp_meta['_dentalia_button_link']['0']!= '' && $orion_wp_meta['_dentalia_button_text']['0']!= '') {
			$display_button = true;
		}
	}

	if ($display_button == false) {
		return;
	} else {
		$menu_btn = "<li class='nav-button'><div class='mainnav-button-wrap'> <a href = '" . $button_link . "' class='btn ". $menu_btn_color ." btn-flat " . $btn_class . "'" . $button_atts . "aria-label='". esc_attr($button_text)."'>" . $button_text. "</a></div></li>";
		return $menu_btn;
	}
}


/* Minify CSS */
function orion_minify_css($input) {
    if(trim($input) === "") return $input;
    return preg_replace(
        array(
            // Remove comment(s)
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')|\/\*(?!\!)(?>.*?\*\/)|^\s*|\s*$#s',
            // Remove unused white-space(s)
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\'|\/\*(?>.*?\*\/))|\s*+;\s*+(})\s*+|\s*+([*$~^|]?+=|[{};,>~+]|\s*+-(?![0-9\.])|!important\b)\s*+|([[(:])\s++|\s++([])])|\s++(:)\s*+(?!(?>[^{}"\']++|"(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')*+{)|^\s++|\s++\z|(\s)\s+#si',
            // Replace `0(cm|em|ex|in|mm|pc|pt|px|vh|vw|%)` with `0`
            '#(?<=[\s:])(0)(cm|em|ex|in|mm|pc|pt|px|vh|vw|%)#si',
            // Replace `:0 0 0 0` with `:0`
            '#:(0\s+0|0\s+0\s+0\s+0)(?=[;\}]|\!important)#i',
            // Replace `background-position:0` with `background-position:0 0`
            '#(background-position):0(?=[;\}])#si',
            // Replace `0.6` with `.6`, but only when preceded by `:`, `,`, `-` or a white-space
            '#(?<=[\s:,\-])0+\.(\d+)#s',
            // Minify string value
            '#(\/\*(?>.*?\*\/))|(?<!content\:)([\'"])([a-z_][a-z0-9\-_]*?)\2(?=[\s\{\}\];,])#si',
            '#(\/\*(?>.*?\*\/))|(\burl\()([\'"])([^\s]+?)\3(\))#si',
            // Minify HEX color code
            '#(?<=[\s:,\-]\#)([a-f0-6]+)\1([a-f0-6]+)\2([a-f0-6]+)\3#i',
            // Replace `(border|outline):none` with `(border|outline):0`
            '#(?<=[\{;])(border|outline):none(?=[;\}\!])#',
            // Remove empty selector(s)
            '#(\/\*(?>.*?\*\/))|(^|[\{\}])(?:[^\s\{\}]+)\{\}#s'
        ),
        array(
            '$1',
            '$1$2$3$4$5$6$7',
            '$1',
            ':0',
            '$1:0 0',
            '.$1',
            '$1$3',
            '$1$2$4$5',
            '$1$2$3',
            '$1:0',
            '$1$2'
        ),
    $input);
}


/* checking if it is a WooCommerce page */
/**
* Must be placed separate from WooCommerce scripts, because it needs to return result even when WooCommerce is not installed.
* @access public
* @return bool
*/
function orion_is_woo() {
	if(  !function_exists ( "is_woocommerce" )) {
		return false;
	} else if (  function_exists ( "is_woocommerce" ) && is_woocommerce()){
        return true;
    } else {
	    $woocommerce_keys = array ( 
			"woocommerce_shop_page_id",
			"woocommerce_terms_page_id",
			"woocommerce_cart_page_id",
			"woocommerce_checkout_page_id",
			"woocommerce_pay_page_id",
			"woocommerce_thanks_page_id",
			"woocommerce_myaccount_page_id",
			"woocommerce_edit_address_page_id",
			"woocommerce_view_order_page_id",
			"woocommerce_change_password_page_id",
			"woocommerce_logout_page_id",
			"woocommerce_lost_password_page_id"
		);
	    foreach ( $woocommerce_keys as $wc_page_id ) {
	        if ( get_the_ID () == get_option ( $wc_page_id , 0 ) ) {
	                return true ;
	        }
	    }
	    return false;
    }
}

if(!function_exists('orion_get_static_blocks')) {
	function orion_get_static_blocks() {
		$block_args = array(
			'posts_per_page'   => -1,
			'offset'           => 0,
			'category'         => '',
			'category_name'    => '',
			'orderby'          => 'date',
			'order'            => 'DESC',
			'exclude'          => '',
			'meta_key'         => '',
			'meta_value'       => '',
			'post_type'        => 'static_blocks',
			'post_mime_type'   => '',
			'post_parent'      => '',
			'author'	   => '',
			'author_name'	   => '',
			'post_status'      => 'publish',
			'suppress_filters' => false 
		);
		$posts_array = get_posts( $block_args ); 

		$static_blocks = array( 'none' => 'None');
		foreach ($posts_array as $block) {
			$id = $block->ID;
			$name = $block->post_title;
			$static_blocks[$id] = $name;
		}
		return $static_blocks;
	}
}


/**
 * Add a custom product data tab
 */
add_filter( 'woocommerce_product_tabs', 'orion_ingredients_product_tab' );
function orion_ingredients_product_tab( $tabs ) {
	global $post;
	$additional_product_tab_content = get_post_meta( $post->ID, '_dentalia_additional_tab_content');
	$additional_product_tab_title = get_post_meta( $post->ID, '_dentalia_additional_tab_title');
	$additional_product_tab_priority = get_post_meta( $post->ID, '_dentalia_additional_tab_priority');
	if (isset($additional_product_tab_content[0]) && isset($additional_product_tab_title[0]) && isset($additional_product_tab_priority[0])) {
		$tabs['ingredients'] = array(
			'title' 	=> $additional_product_tab_title['0'],
			'priority' 	=> $additional_product_tab_priority['0'],
			'callback' 	=> 'orion_additional_product_tab_content'
		);		
	}
	return $tabs;

}
function orion_additional_product_tab_content() {
	global $post;
	$additional_product_tab_content = get_post_meta( $post->ID, '_dentalia_additional_tab_content');	
	if (isset($additional_product_tab_content[0])) : ?>
		<?php echo wpautop(wp_kses_post($additional_product_tab_content[0]), true);?>
	<?php endif;
}



function orion_custom_postloop_templates( $templates ) {
	$templates[] = 'templates/blog/content-blog-classic.php';
	$templates[] = 'templates/blog/content-blog-grid.php';
	$templates[] = 'templates/blog/content-blog-grid3.php';

	return $templates;
}
add_filter( 'siteorigin_panels_postloop_templates', 'orion_custom_postloop_templates' );



if(!function_exists('orion_get_readme_btn_classes')) {
	function orion_get_readme_btn_classes() {
		global $orion_options;
		if(empty($orion_options)) {
			$orion_options = orion_get_orion_defaults();
		}		
		if (array_key_exists('blog_readme_button', $orion_options)) {
			return $orion_options['blog_readme_button'];
		} else {
			return 'btn';
		}
	}
}

/*This function doesn't do anything, but must be left here for users which have outdated Dentalia plugin version (1.x)*/
function orion_theme_add_so_widgets() {
}