<?php function orion_backend_colors() { 

$color_1 = orion_get_theme_option_css('main_theme_color', '#00b2ca' );
$color_2 = orion_get_theme_option_css('secondary_theme_color', '#3F51B5' );
$color_3 = orion_get_theme_option_css('color_3', '#2B354B' );

$paragraph_colors_dark = orion_get_theme_option_css('paragraph_colors_dark', '#757575' );
$heading_colors_dark = orion_get_theme_option_css('heading_colors_dark', '#212121' );
$paragraph_colors_light = orion_get_theme_option_css('paragraph_colors_light', '#fff' );
$heading_colors_light = orion_get_theme_option_css('heading_colors_light', '#fff' );
$site_background_color = orion_get_theme_option_css('site_background_color', '#fff' );
$alt_site_background_color = orion_get_theme_option_css('alt_site_background_color', '#f4f8fa' );

$link_colors_dark_regular = orion_get_theme_option_css(array('link_colors_dark','regular'), '#212121');

  /*Font families */
$content_font = orion_get_theme_option_css(array('content_font','font-family'), 'Open Sans');
$title_font = orion_get_theme_option_css(array('title_font','font-family'), 'Open Sans');
$button_nav_font = orion_get_theme_option_css(array('button_nav_font','font-family'), 'Open Sans');
?>

.bg-c1, input[value="bg-c1"], input[type="radio"][value="color_1"] {
  background-color: <?php echo esc_attr($color_1);?>;
}
.bg-c2, input[value="bg-c2"], input[type="radio"][value="color_2"] {
  background-color: <?php echo esc_attr($color_2);?>;
}
.bg-c3, input[value="bg-c3"], input[type="radio"][value="color_3"] {
  background-color: <?php echo esc_attr($color_3);?>;
}

.bg-sitebg, input[value="bg-sitebg"], input[type="radio"][value="bg-sitebg"],
input[type="radio"][value="color_sitebg"],
.bg-content-bg, input[value="bg-content-bg"], input[type="radio"][value="bg-content-bg"], .edit-post-visual-editor {
  background-color: <?php echo esc_attr($site_background_color);?>;
}

.bg-altsitebg, input[value="bg-altsitebg"], input[type="radio"][value="bg-altsitebg"],
input[type="radio"][value="altsitebg"],
input[type="radio"][value="color_altsitebg"] {
  background-color: <?php echo esc_attr($alt_site_background_color);?>;
}

:root {
	--color-1: <?php echo esc_html($color_1);?>;
  	--color-2: <?php echo esc_html($color_2);?>;
  	--color-3: <?php echo esc_html($color_3);?>;
  	--color-sbg: <?php echo esc_html($site_background_color);?>;
  	--color-sbg-alt: <?php echo esc_html($alt_site_background_color);?>;

	<?php // text colors */?>
  	--color-p-dark: <?php echo esc_html($paragraph_colors_dark);?>;
  	--color-h-dark: <?php echo esc_html($heading_colors_dark);?>;

  	--color-p-light: <?php echo esc_html($paragraph_colors_light);?>;
  	--color-h-light: <?php echo esc_html($heading_colors_light);?>;

    --color-a-dark: <?php echo esc_html($link_colors_dark_regular);?>;
  
  <?php /* Font families */ ?>
    --content-font: <?php echo esc_html($content_font);?>;
    --title-font: <?php echo esc_html($title_font);?>;
    --button-font: <?php echo esc_html($button_nav_font);?>;    
}
<?php
}
