<?php 

/*********************/
/* demo import files */
/*********************/
function orion_ocdi_import_files() {
  return array(
    array(
      'import_file_name'           => 'Demo Import 1',
      'import_file_url'            => 'https://downloads.orionthemes.com/demo-content/dentalia-2_3/OCDI2/content.xml',
      'import_widget_file_url'     => 'https://downloads.orionthemes.com/demo-content/dentalia-2_3/OCDI2/widgets.json',
      'import_customizer_file_url' => 'https://downloads.orionthemes.com/demo-content/dentalia-2_3/OCDI/customizer.dat',
      'import_redux'               => array(
        array(
          'file_url'    => 'https://downloads.orionthemes.com/demo-content/dentalia-2_3/OCDI/theme-options.json',
          'option_name' => 'dentalia',
        ),
      ),
      'import_preview_image_url'   => 'https://downloads.orionthemes.com/demo-content/dentalia-2_3/OCDI/preview.png',
      'import_notice'              => __( 'Dentalia main demo.', 'dentalia' ),
      'preview_url'                => 'http://dentalia.orionthemes.com/demo-1',
    ),
  );
}
add_filter( 'ocdi/import_files', 'orion_ocdi_import_files' );



/*********************/
/*   after import    */
/*********************/
/**
 * Execute custom code after the whole import has finished.
 */
function orion_ocdi_after_import_setup() {
  // Assign menus to their locations.
  $main_menu = get_term_by( 'name', 'Menu 1', 'nav_menu' );

  set_theme_mod(
    'nav_menu_locations', array(
      'primary' => $main_menu->term_id,
    )
  );
  // Assign front page and posts page (blog page).
  $front_page_id = get_page_by_title( 'Home' );
  $blog_page_id  = get_page_by_title( 'Blog' );
  update_option( 'show_on_front', 'page' );
  update_option( 'page_on_front', $front_page_id->ID );
  update_option( 'page_for_posts', $blog_page_id->ID );
}
add_action( 'ocdi/after_import', 'orion_ocdi_after_import_setup' );

/* Import revolution slider from dentalia-plugin */
function orion_ocdi_after_import_revslider() {
  if ( class_exists( 'RevSlider' ) ) {

      $sliders_array = array(
          'demo-1' => array('dentalia-slider-1.zip','dentalia-slider-2.zip','dentalia-slider-3.zip'),
      );

    $dentalia_plugin_dir = WP_PLUGIN_DIR.'/dentalia-plugin/';
    $slider_location = 'admin/redux-extensions/extensions/wbc_importer/demo-data/demo-1/';

      if (isset($dentalia_plugin_dir)) {
         if (is_array($sliders_array['demo-1'])) {
              foreach ($sliders_array['demo-1'] as $slider_filename) {
                $slider_file_loc = $dentalia_plugin_dir . $slider_location . $slider_filename;
                  if ( file_exists( $slider_file_loc) && class_exists( 'RevSliderSlider' )) {
                      $slider = new RevSliderSlider();
                      $slider->importSliderFromPost( true, true, $slider_file_loc );
                  }                        
              }
          }
      }
  }
}
add_action( 'ocdi/after_import', 'orion_ocdi_after_import_revslider' );


/* Prevent upgrade to version 2 notification */
function orion_set_theme_options_version() {
  update_option( 'dentalia_version_check', 2 );
}
add_action( 'ocdi/after_import', 'orion_set_theme_options_version' );

/*********************/
/*  plugin install   */
/*********************/

function orion_ocdi_register_plugins( $plugins ) {
  $theme_plugins = array(
        array(
            'name' => esc_html__('Dentalia Theme Plugin', 'dentalia'),
            'description' => esc_html__( 'Provides essential theme functionality.' , 'dentalia' ),
            'slug' => 'dentalia-plugin', 
            'source' => esc_url('https://orionthemes.com/downloads/dentalia/dentalia_plugin_2/dentalia-plugin.zip'), 
            'required' => true,
            'force_activation' => false, 
            'force_deactivation' => false, 
            'external_url' => 'https://orionthemes.com/',
        ),     
        array(
            'name'      => esc_html__('Page Builder by SiteOrigin', 'dentalia'),
            'description' => esc_html__( 'Page builder used in the demo pages.' , 'dentalia' ),
            'source' => esc_url('https://downloads.orionthemes.com/dentalia/thirdparty/siteorigin-panels.zip'), 
            'slug'      => 'siteorigin-panels',
            'required'  => true,
            'force_activation' => false,
            'force_deactivation' => false,
        ),                    
        array(
            'name'      => esc_html__('SiteOrigin Widgets Bundle', 'dentalia'),
            'description' => esc_html__( 'Unlocks 30+ Dentalia widgets.' , 'dentalia' ),
            'slug'      => 'so-widgets-bundle',
            'required'  => true,
        ),
        array(
            'name' => esc_html__('Contact form 7', 'dentalia'),
            'description' => esc_html__( 'Used for contact forms in the demo.' , 'dentalia' ),
            'slug' => 'contact-form-7', 
            'preselected' => true,
        ),        
        array(
            'name' => esc_html__('Revolution Slider WP', 'dentalia'),
            'description' => esc_html__( 'Premium slider plugin used in the demo.' , 'dentalia' ),
            'slug' => 'revslider', 
            'source' => esc_url('https://orionthemes.com/downloads/dentalia/thirdparty/revslider.zip'), 
            'required' => false,
            'force_activation' => false, 
            'force_deactivation' => false, 
        ), 
  );
 
  // return array_merge( $plugins, $theme_plugins );
  return $theme_plugins;
}
add_filter( 'ocdi/register_plugins', 'orion_ocdi_register_plugins' );



/* OCDI settings */
function orion_ocdi_plugin_page_setup( $default_settings ) {
    $default_settings['parent_slug'] = 'themes.php';
    $default_settings['page_title']  = esc_html__( 'Dentalia Demo Import' , 'dentalia' );
    $default_settings['menu_title']  = esc_html__( 'Import Dentalia Demo' , 'dentalia' );
    $default_settings['capability']  = 'import';
    $default_settings['menu_slug']   = 'one-click-demo-import';
 
    return $default_settings;
}
add_filter( 'ocdi/plugin_page_setup', 'orion_ocdi_plugin_page_setup' );