"use strict";

jQuery(function($) {
	// $('.owl-carousel').addClass('tiny-slider-container').removeClass('.owl-carousel');

	$('.carousel-wrap').each( function() {
 
		const carousel = $(this); 
		const unique = 'sid-' + Math.random().toString(36).substr(2, 9);
		const uniqueId = '#'+ unique + '.carousel-wrap';
		$(carousel).attr('id', unique);

		let items = 1;
		let slideBy = 1;
		let slideByTablet = 1;
	 	let autoplay = false;
	 	let childCount = $('.item', carousel).length;
	 	let number_items = 1;
	 	let number_items_tablet = 1;
	 	let number_items_desktop = 4;
	 	let startIndex = 0;
	 	let timeout = 10000;

	 	// navigation behaviour
	 	let data_slideby = 0;
		let slideByDesktop = 1;
		let slideByItems = 1;
		let dots = false;

		/* slide behaviour */

		// number of items in a row
		if ( carousel.attr('data-col')) {
			number_items_desktop = parseInt(carousel.attr("data-col"));
			// console.log('number_items_desktop: ' + number_items_desktop);
		} 
		if (number_items_desktop == 12) {
			number_items_tablet = 3;
			number_items = 6;
		} else if (number_items_desktop == 6) {
			number_items = 3;
			number_items_tablet = 3;		
		} else if (number_items_desktop > 4) {
			number_items = 4;
		} else {
			number_items = number_items_desktop;
		}
		if (6 > number_items_desktop && number_items_desktop > 1 ) {
			number_items_tablet = 2;
		}
		if (carousel.attr('data-tablet')) {
			number_items_tablet = carousel.attr("data-tablet");
		}

		// slideby
		if ( carousel.attr('data-slideby')) {
			data_slideby = parseInt(carousel.attr("data-slideby"));
		} 
		if (number_items_desktop > (childCount / 2)) {
			slideByDesktop = 1;
		} else if (data_slideby != 0 && data_slideby <= number_items_desktop) {
			slideByDesktop = data_slideby;
		} else {
			slideByDesktop = number_items_desktop;
		}
		if (number_items > (childCount / 2)) {
			slideByItems = 1;
		} else if (data_slideby != 0 && data_slideby <= number_items) {
			slideByItems = data_slideby;
		} else {
			slideByItems = number_items;
		}
		if(number_items_tablet > (childCount / 2)) {
			slideByTablet = 1;
		} else if (data_slideby != 0 && data_slideby <= number_items_tablet) {
			slideByTablet = data_slideby;
		} else {
			slideByTablet = number_items_tablet;
		}


		/* autoplay */
		if ( carousel.attr('data-autoplay')) {
			if (carousel.attr('data-autoplay') == 1 || carousel.attr('data-autoplay') == 'true') {
				autoplay = true;
			}
		} 	
		if ( carousel.attr('data-dots')) {
			if (carousel.attr('data-dots') == 1 || carousel.attr('data-dots') == 'true') {
				dots = true;
			}
		} 	
		if ( carousel.attr('data-autoplaytimeout')) {
			timeout = carousel.attr('data-autoplaytimeout');
		} 


		/* fade or normal transition */
		let mode = 'carousel';
		let animateOut = 'tns-fadeOut';	

		// console.log(slideByItems);
		if (slideByItems == 1 && number_items_desktop == 1) {
			// mode = 'gallery';
			// animateOut = 'none';
		} 



		/* initiate Tiny slider*/
		let slider = tns({ 
 
 			mode: mode,  // fade or normal transition
 			animateOut: animateOut, // fade or normal transition
			startIndex: startIndex,
			container: uniqueId,
			controls: false,
			items: number_items,
			slideBy: 1,
			gutter: 0,
			autoplayHoverPause: true,
			autoplay: autoplay,
			autoplayTimeout: timeout,
			nav: dots,
			arrowKeys: true,
			autoplayButtonOutput: false,
			speed: 600,
			mouseDrag: true,
			loop: true,
			navPosition: 'bottom', 
			responsive:{
			    0:{
			        items:1,
			        nav:dots,
			        slideBy: 1,
			    }, 
			    600:{ 
			        items:number_items_tablet,
			        nav:dots,
			        slideBy: slideByTablet,
			    },
			    992:{
			        items: number_items,
			        nav:dots,
			        slideBy: slideByItems,		        
			    },
			    1200:{
			        items: number_items_desktop,
			        nav:dots,
			        slideBy: slideByDesktop,			        
			    }		        
			}

		});
		
		let widget = $(carousel).closest('.widget');

		/* pause when pointer is on the widget*/
		widget.on('mouseover', function(){
			slider.pause();
		});
		widget.on('mouseout', function(){
			slider.play();
		})
		/* custom navigation support */
		$('.owlprev', widget).on('click', function(){
			slider.goTo('prev');
		});
		$('.owlnext', widget).on('click', function(){
			slider.goTo('next');
		});

		/* tabbed navigation */
		if ($('.nav-tabs', widget).length) {
			$('.nav-tabs .owl-nav-link', widget).each(function(){
				$(this).on('click', function(){
					var tnsindex = $(this).data('tnsindex');
					slider.goTo(+tnsindex);
					// slider.goTo(2);
					console.log($(this).data('tnsindex'));
				})
			})
		}
		/* advanced carousel navigation */
		$('.carousel-navigation.nav-tabs > li > a').on('click', function() {
			var advCarouselTab = $(this).parent('li');
			advCarouselTab.addClass('active');
			advCarouselTab.siblings().removeClass('active');			
		});

		/* works */
		// slider.events.on('indexChanged', function(event) {
		// 	console.log('index changed');
		// 	console.log(event);
		// });

		/* remove URL hash when slide changes */
		slider.events.on('indexChanged', function(event) {
    		var urlHash = window.location.hash;
    		if (urlHash != '') {
    			var dataSearchQuery = urlHash.replace("#", "");
    			var navTab = $('.carousel-navigation a[data-navid='+ dataSearchQuery +']').parent('li');
    			navTab.addClass('active');
    			navTab.siblings().removeClass('active');
    			history.replaceState(null, null, ' ');
    		}		
		});	

		/* click on the tab, if there is a hash in url, which matches the slide ID */
		var urlHash = window.location.hash;
    	if (urlHash != '') {
    		var dataSearchQuery = urlHash.replace("#", "");
    		if ($('.carousel-navigation a[data-navid='+ dataSearchQuery +']', widget).length) {
    			$('.carousel-navigation a[data-navid='+ dataSearchQuery +']', widget).click();
    		}
		}
	})
})	/*end jQuery*/	

// function slideChange(info) {
// 	console.log(info.index);
// }