"use strict";

function isGutenbergActive() {
    return typeof wp !== 'undefined' && typeof wp.blocks !== 'undefined';
}

jQuery(function($) { 
/*-----------------------------------------------------------------------------------*/
/* OWL carusel 
/*-----------------------------------------------------------------------------------*/

	if (isGutenbergActive()) {
		setTimeout(orionOwl , 100);
	}

	$( orionOwl );

	function orionOwl() {	
		jQuery.each($('.owl-carousel'), function() {
			var owl = $(this);
			var childCount = $('.item', owl).length;
			
			var number_items = 1;
			var number_items_desktop = 4;

			var owlAutoplay = true;
			var number_items_tablet = 1;
			var dots = false;
			var margin = 0;
			var owlAutoheight = false;

			var rtl = ($('html').attr('dir')=='rtl');

			//dots
			if ( owl.attr('data-dots') == '1') {
				dots = true;
			}
			//autoplay
			if ( owl.attr('data-autoplay')) {
				var owlAutoplayAtt = (owl.attr('data-autoplay') == 'true' || owl.attr('data-autoplay') == '1');
				if (owlAutoplayAtt != true) {
					owlAutoplay = false;	
				}
			}
			//autoheight
			if ( owl.attr('data-autoheight')) {
				var owlAutoheight = (owl.attr('data-autoheight') == 'true' || owl.attr('data-autoheight') == '1');
			}
			//margin
			if ( owl.attr('data-margin')) {
				margin = parseInt(owl.attr("data-margin"));
			}
			// number of items in a row
			if ( owl.attr('data-col')) {
				number_items_desktop = parseInt(owl.attr("data-col"));
			} 
			if (number_items_desktop == 12) {
				number_items_tablet = 3;
				number_items = 6;
			} else if (number_items_desktop == 6) {
				number_items = 3;
				number_items_tablet = 3;		
			} else if (number_items_desktop > 4) {
				number_items = 4;
			} else {
				number_items = number_items_desktop;
			}
			if (6 > number_items_desktop && number_items_desktop > 1 ) {
				number_items_tablet = 2;
			}
			if (owl.attr('data-tablet')) {
				number_items_tablet = owl.attr("data-tablet");
			}

			// loop
			var owlLoop = 'true';
			if (owl.attr('data-owlloop')) {
				owlLoop = owl.attr('data-owlloop');
			}		

			// navigation behaviour
			var data_slideby = 0;
			var slideByDesktop = 1;
			var slideByItems = 1;
			var slideByTablet = 1;
			var autoplayTimeout = 5000;
			if ( owl.attr('data-autoplaytimeout') ) {
				autoplayTimeout = parseInt(owl.attr("data-autoplaytimeout"));
			} 		
			if ( owl.attr('data-slideby')) {
				data_slideby = parseInt(owl.attr("data-slideby"));
			} 
			if (number_items_desktop > (childCount / 2)) {
				slideByDesktop = 1;
			} else if (data_slideby != 0 && data_slideby <= number_items_desktop) {
				slideByDesktop = data_slideby;
			} else {
				slideByDesktop = number_items_desktop;
			}
			if (number_items > (childCount / 2)) {
				slideByItems = 1;
			} else if (data_slideby != 0 && data_slideby <= number_items) {
				slideByItems = data_slideby;
			} else {
				slideByItems = number_items;
			}
			if(number_items_tablet > (childCount / 2)) {
				slideByTablet = 1;
			} else if (data_slideby != 0 && data_slideby <= number_items_tablet) {
				slideByTablet = data_slideby;
			} else {
				slideByTablet = number_items_tablet;
			}
			var owlTimeout;

			var hashListner = false;
			if (owl.attr('data-hashlisten')) {
				var hashListner = owl.attr('data-hashlisten');
			}
			var isloop = (owlLoop == 'true');

			owl.owlCarousel({ 
				rtl: rtl,
			    loop: isloop,
			   	URLhashListener: hashListner,
			    startPosition: 'URLHash',
			    animateOut: 'fadeOut',
			    autoplay: owlAutoplay,
			    autoplayHoverPause: true,
			    autoplaySpeed: 500,
			    autoplayTimeout: autoplayTimeout,
			    responsiveClass:true,
			    autoHeight: owlAutoheight,		    
			    dots: dots,
			    margin: margin,
			    responsive:{
			        0:{
			            items:1,
			            nav:false,
			            slideBy: 1,
			        },
			        600:{
			            items:number_items_tablet,
			            nav:false,
			            slideBy: slideByTablet
			        },
			        992:{
			            items: number_items,
			            nav:false,
			            slideBy: slideByItems
			        },
			        1200:{
			            items: number_items_desktop,
			            nav:false,
			            slideBy: slideByDesktop,
			        }		        
			    }
			})
			if (owl.hasClass('owl-equal-height')) {
				//set images as bg image
				owlSetBgImage(owl);
				owlUpdateSize(owl);
			}	
			if (owl.hasClass('owl-correct-height')) {
				// page builder is not fully propagated yet, so we correct the size after 1s
				owlCorrectHeight(owl);
				if(owl.find('.widget_orion_tabs_w')) {
					$('.tabs-wrap a[role=tab]', owl).on('click', function(){
						owlCorrectHeight(owl);
					}); 
				}
			}				
			owl.on('changed.owl.carousel', function(event) {

	    		var urlHash = window.location.hash;
	    		if (urlHash != '') {
	    			var dataSearchQuery = urlHash.replace("#", "");
	    			var navTab = $('.carousel-navigation a[data-navid='+ dataSearchQuery +']').parent('li');
	    			navTab.addClass('active');
	    			navTab.siblings().removeClass('active');
	    			history.replaceState(null, null, ' ');
	    		}

			})	

			if (owlAutoplay == true) {
				/* stop autoplay */     
		        $(owl).on('mouseleave', function(){ 
					owl.trigger('play.owl.autoplay');
		   		});
		   		$(owl).on('mouseenter', function(){
		   			owl.trigger('stop.owl.autoplay');
		   		});

		   		/* stop autoplay */
		   		var navlinks = $(owl).closest('.so-panel.widget').find(
		   		('.owl-nav-link'));
		   		if (navlinks.length) {
		   			navlinks.on('mouseenter',function(){
						owl.trigger('stop.owl.autoplay');
		   			});
		   				navlinks.on('mouseleave',function(){
						owl.trigger('play.owl.autoplay');
		   			});
		   		}
	        }
			// If there is navigation, use it.
		    owl.siblings().find('.owlnext').on('click', function(){
		      	owl.trigger('next.owl.carousel');
		    });
		    owl.siblings().find('.owlprev').on('click', function(){
		      	owl.trigger('prev.owl.carousel');
		    });   
		})
	}
	/* equal height carousel */
	function owlUpdateSize($carousel) {
		var minratio = $carousel.data('minratio');
		var owlWidth = $carousel.innerWidth();
		var owlHeight = parseInt(owlWidth * minratio);
		// set size
		$carousel.height(owlHeight);
		$('.owl-item', $carousel).height(owlHeight);
	}
	function owlCorrectHeight($carousel) {
		setTimeout(function() {
			var slideHeight = $('> .owl-stage-outer > .owl-stage > .owl-item.active', $carousel).outerHeight();
			$('> .owl-stage-outer', $carousel).height(slideHeight);
		}, 1000);	
	}

	function owlSetBgImage($carousel) {
		$('.owl-item', $carousel).each(function () {
			// set image
			var $this = $(this);
			var $image = $this.find('img');
			var imageSource = $image.attr('src');
		    $this.css('backgroundImage', 'url(' + imageSource + ')');
		});
	}
	/* fix for accordion within owl carousel  */
	$('.so-widget-orion_advanced_carousel_w .widget_orion_accordion_w .panel-heading').on('click', function(){
		$('.so-widget-orion_advanced_carousel_w .owl-stage-outer').css('height', '');
	})

/*-----------------------------------------------------------------------------------*/
/* END OWL carusel
/*-----------------------------------------------------------------------------------*/

})