"use strict";
 
jQuery(function($) {

	var orionSvgs = new Object();


	// orionSvgs.svg_1 = '<svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1440 36"><path fill="{{svgBgColor}}" d="M1437,0h-7H758c-1.65,0-3.955,0.955-5.121,2.121L722.12,32.879c-1.167,1.167-3.076,1.166-4.242,0	L687.121,2.122C685.955,0.955,683.65,0,682,0H10H3H0v3v30v3h3h7h1420h7h3v-3V3V0H1437z"/></svg>';
	// orionSvgs.svg_13 = '<?xml version="1.0" encoding="UTF-8"?><svg enable-background="new 0 0 1440 72" version="1.1" viewBox="0 0 1440 72" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"><g fill="{{svgBgColor}}"><path d="m360 11.993c120 0 240 10.085 360 30.251 34.031 5.344 68.06 9.904 102.09 13.731 85.97 9.673 171.94 14.536 257.91 14.536 111.63 0 223.26-8.164 334.89-24.473 8.37-1.222 16.743-2.48 25.113-3.795v-12.18s-18.02 2.781-27.041 4.099c-110.55 16.151-222.61 24.341-333.06 24.341-84.943 0-171.24-4.865-256.5-14.458-34.062-3.831-68.206-8.423-101.49-13.649-120.04-20.17-241.77-30.396-361.81-30.396-119.47 0-240.61 10.134-360.1 30.113v12.131c120-20.166 240-30.251 360-30.251z" opacity=".3"/><path d="m1080 70.512c-85.971 0-171.94-4.863-257.91-14.536-34.031-3.828-68.06-8.388-102.09-13.732-120-20.166-240-30.251-360-30.251s-240 10.085-360 30.251v29.756h1440v-29.756c-8.37 1.314-16.743 2.573-25.113 3.795-111.63 16.309-223.26 24.473-334.89 24.473z"/></g></svg>';
	// orionSvgs.svg_13 = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 72"><path fill="{{svgBgColor}}" d="M360,12A2169.33,2169.33,0,0,1,720,42.24q51,8,102.09,13.73A2303.28,2303.28,0,0,0,1080,70.51,2313.49,2313.49,0,0,0,1414.89,46q12.55-1.83,25.11-3.8V30.06s-18,2.78-27,4.1A2312,2312,0,0,1,1079.9,58.5,2303.84,2303.84,0,0,1,823.4,44.05c-34.06-3.84-68.2-8.43-101.49-13.65A2190.08,2190.08,0,0,0,360.1,0,2190,2190,0,0,0,0,30.11V42.24A2169.33,2169.33,0,0,1,360,12Z" style="opacity:0.3"/><path fill="{{svgBgColor}}" d="M1080,70.51A2305.65,2305.65,0,0,1,822.09,56Q771,50.24,720,42.24a2157.27,2157.27,0,0,0-720,0V72H1440V42.24q-12.55,2-25.11,3.8A2313.49,2313.49,0,0,1,1080,70.51Z"/></svg>';
	/*check if is hex color */
	function is_hexadecimal(str) {
		var regexp = /^[0-9a-fA-F]+$/;
	    if (regexp.test(str)) {
	        return true;
	    } else {
	        return false;
	    }
	}

	/* create a row with separator */
	$.fn.createSvgFile = function(position, fileName, color){
		var row = $(this);
		var datatypeAttr = '';
		var separator = '';
		var placement = '';
		var svg = '';
		var zIndexAttr = '';
		var zIndexAttribute = ' style="z-index:2;"';
		
		var SvgPath = orionColors.svg_path;

		var dataType = $(this).attr('data-stretch-type');
		if (dataType != undefined) {
			if (dataType == 'full') {
				dataType = 'full-stretched';
			}
			datatypeAttr = 'data-stretch-type="'+ dataType + '"';
		}

		var zIndex = $(this).attr('data-z-index');
		if (zIndex != undefined) {
			zIndexAttribute = ' style="z-index:'+ (parseInt(zIndex) + 1) + '"';
		}

		if (position == 'bottom-svg-inside' || position == 'bottom-svg-outside') {
			placement = 'bottom';
		} else {
			placement = 'top';
		}

		var classList = $(this).attr('class').split(/\s+/);
		if (placement == 'bottom') {
			var newClassList = classList.filter(function (item) {
   				return item.indexOf("top-") !== 0;
   			});
		} else {
			var newClassList = classList.filter(function (item) {
	   			return item.indexOf("bottom-") !== 0;
			});			
		}
		newClassList = newClassList.filter(function(e) { return e !== 'middle_align' });
		newClassList = newClassList.filter(function(e) { return e !== 'bottom_align' });
		newClassList = newClassList.filter(function(e) { return e !== 'orion-equal-height' });
		newClassList = newClassList.filter(function(e) { return e !== 'full-screen-row' });
		newClassList = newClassList.join(' ');		

		// get svg object property
		var svgProperty = fileName.replace('-', '_');
		// console.log(svgProperty);
		if (orionSvgs.hasOwnProperty(svgProperty)) {

			separator = orionSvgs[svgProperty];
			if (separator.includes("{{svgBgColor}}")) {
				separator = separator.replace(/{{svgBgColor}}/g, color);
			}
			if (placement == 'top') {
				var svg = '<div class="' + newClassList + ' svg-wrap-animate svg-wrap wrap-top"' + datatypeAttr + zIndexAttribute + '><div class="svg-w">' + separator + '</div></div>';
				row.before(svg);
			} else {
				var svg = '<div class="' + newClassList + ' svg-wrap-animate svg-wrap wrap-bottom"' + datatypeAttr + zIndexAttribute + '><div class="svg-w">' + separator + '</div></div>';
				row.after(svg);
			}

		} else {
			var file = SvgPath + fileName + '.svg';
			// console.log(fileName);
			jQuery.get(file, function(separator) {

				if (separator.includes("{{svgBgColor}}")) {
					separator = separator.replace(/{{svgBgColor}}/g, color);
				}
				if (placement == 'top') {
					var svg = '<div class="' + newClassList + ' svg-wrap-animate svg-wrap wrap-top"' + datatypeAttr + zIndexAttribute + '><div class="svg-w">' + separator + '</div></div>';
					// $(svg).css('z-index', zIndexSeparator);
					row.before(svg);
				} else {
					var svg = '<div class="' + newClassList + ' svg-wrap-animate svg-wrap wrap-bottom"' + datatypeAttr + zIndexAttribute + '><div class="svg-w">' + separator + '</div></div>';
					// $(svg).css('z-index', zIndexSeparator);
					row.after(svg);
				}
			},'text');
		}
	}


	function getSvgColor(color) {
		/* returns hex color value */
		if(color == 'bg-content-bg' || color == undefined) {
			// check the site bg color
			var siteContentBgAtt = $('body').attr("data-site-content-bg");
			if (typeof siteContentBgAtt !== typeof undefined && siteContentBgAtt !== false) {
			    color = siteContentBgAtt;
			} else {
				color = '#fff';
			}
		}
		if ( ! is_hexadecimal(color)) {
			if (color in orionColors) {
				color = orionColors[color];
			}
		}
		return color;
	}

	$( document ).ready(function() {
		var oSeparator = $('.orion-separator:not(.svg-wrap)');
		var oSeparatorLength = oSeparator.length;

		$('.orion-separator:not(.svg-wrap)').each(function(index, element){
			var fileName = '';
			var position = '';
			var color = '';
			
			var classList = this.className.split(' ');
			var classArray = $(this).prop("classList");

			// top SVGs
			if (classList.includes("top-svg-inside") || classList.includes("top-svg-outside")) {
				var startsWithTop = classList.filter(/./.test.bind(/^top-svg-[0-9]/));

				var htmlClass = startsWithTop[0];
				var fileName = htmlClass.replace('top-','');
				if (classList.includes("top-svg-inside")) {
					position = 'top-svg-inside';
				} else {
					position = 'top-svg-outside';
				}
				var color = $(this).data('svgTopColor');
				var hex = getSvgColor(color);
				$(this).createSvgFile(position, fileName, hex);
			}
			// bottom SVGs
			if (classList.includes("bottom-svg-inside") || classList.includes("bottom-svg-outside")) {
				var startsWithTop = classList.filter(/./.test.bind(/^bottom-svg-[0-9]/));
				var htmlClass = startsWithTop[0];
				var fileName = htmlClass.replace('bottom-','');
				if (classList.includes("bottom-svg-inside")) {
					position = 'bottom-svg-inside';
				} else {
					position = 'bottom-svg-outside';
				}			
				var color = $(this).data('svgBottomColor');
				var hex = getSvgColor(color);
				$(this).createSvgFile(position, fileName, hex);
				
			}
			if (index === (oSeparatorLength - 1)) { 
				// we need to trigger resize and wait for page builder to set their streched rows.
				setTimeout(function() {
				 	$('.svg-wrap-animate').removeClass('svg-wrap-animate');
				 	$(window).trigger('resize');			
		   	   	}, 100);
		   	   	setTimeout(function() {
				 	$('.svg-wrap-animate').removeClass('svg-wrap-animate');
				 	$(window).trigger('resize');			
		   	   	}, 600);
	        }
		})
	})
})