<?php
/**
 * Malware Scan Page
 *
 * @package BackupBuddy
 */

/**
 * Display Array in multiline form.
 *
 * @param array $array  Array to display.
 * @param bool  $echo   Echo return output.
 *
 * @return string  Multilined html string.
 */
function itbub_lined_array( $array, $echo = true ) {
	if ( is_array( $array ) ) {
		foreach ( $array as $array_key => $array_item ) {
			if ( is_array( $array_item ) ) {
				$array[ $array_key ] = '<div class="data-line">' . itbub_lined_array( $array_item, false ) . '</div>';
			}
		}
		$return = '<div class="data-group">' . implode( '<br>', $array ) . '</div>';
	} else {
		if ( empty( $array ) ) {
			$return = '<div class="data-line"><i>' . esc_html__( 'none', 'it-l10n-backupbuddy' ) . '</i></div>';
		} else {
			$return = $array;
		}
	}

	if ( false === $echo ) {
		return $return;
	}

	echo $return;
}

if ( ! defined( 'pluginbuddy_importbuddy' ) ) {
	pb_backupbuddy::$ui->title( __( 'Malware Scan', 'it-l10n-backupbuddy' ) );
	pb_backupbuddy::disalert( 'it-security_ad', '<b>Is your site locked down & secure?</b><br> Check out <a href="http://ithemes.com/security/?utm_source=BackupBuddy%20Malware%20Scan%20Page&utm_medium=bub%20link&utm_campaign=itsec%20%2B%20bub" target="_blank">iThemes Security Pro</a>, for the do-it-yourself WP security toolbox, or have the website security professionals at <a href="http://ithemes.com/sucuri?utm_medium=bub%20link&utm_campaign=sucuri%20%2B%20bub">Sucuri</a> do it for you.' );
	$url = home_url();
} else {
	$url = str_replace( $_SERVER['QUERY_STRING'], '', $_SERVER['REQUEST_URI'] );
	$url = str_replace( basename( $url ), '', $url );
	$url = 'http://' . $_SERVER['HTTP_HOST'] . $url;
}
?>
<style type="text/css">
	.inside label {
		display: block;
		vertical-align: top;
		width: 140px;
		font-weight: bold;
	}
	.inside .data-group {
		margin-bottom: 15px;
		margin-bottom: 1em;
	}
	.inside .data-group:last-of-type {
		margin-bottom: 0;
	}
</style>

<?php
pb_backupbuddy::$ui->start_metabox( __( 'Malware Scan URL', 'it-l10n-backupbuddy' ), true, 'width: 100%;' );

echo $url;

$continue_1 = true;
if ( $url == 'http://localhost' ) {
	_e( 'ERROR: You are currently running your site locally. Your site must be internet accessible to scan.', 'it-l10n-backupbuddy' );
	$continue_1 = false;
}

if ( true === $continue_1 ) {

	if ( ! empty( $_GET['refresh'] ) ) {
		delete_transient( 'pb_backupbuddy_malwarescan' );
	}

	if ( ! defined( 'pluginbuddy_importbuddy' ) ) {
		$scan = get_transient( 'pb_backupbuddy_malwarescan' );
	} else {
		$scan = false;
	}

	if ( false === $scan ) {
		?>
		<div id="pb_backupbuddy_malwarescanloading">
		<table><tr><td><img src="<?php echo pb_backupbuddy::plugin_url(); ?>/images/loading_large.gif" /></td><td><h1>&nbsp;<?php esc_html_e( 'Scanning for Malware... Please wait...', 'it-l10n-backupbuddy' ); ?></h1></td></tr></table>
		</div>
		<?php
		flush();

		$scan = wp_remote_get(
			'http://sitecheck.sucuri.net/scanner/?scan=' . urlencode( $url ) . '&serialized&clear=true',
			array(
				'method'      => 'GET',
				'timeout'     => 45,
				'redirection' => 5,
				'httpversion' => '1.0',
				'blocking'    => true,
				'headers'     => array(),
				'body'        => null,
				'cookies'     => array(),
			)
		);

		if ( is_wp_error( $scan ) ) {
			pb_backupbuddy::alert( __( 'ERROR #24452. Unable to load Malware Scan results. Details:', 'it-l10n-backupbuddy' ) . ' ' . $scan->get_error_message(), true );
			$scan = 'N;';
		} else {
			$scan = $scan['body'];
			set_transient( 'pb_backupbuddy_malwarescan', $scan, 60 * 60 * 1 ); // 1 hour cache.
		}
		?>
		<script type="text/javascript">
			jQuery(document).ready(function() {
				jQuery('#pb_backupbuddy_malwarescanloading').slideToggle();
			});
		</script>
	<?php
	}

	$continue_2 = true;
	if ( 'N;' == substr( $scan, 0, 2 ) ) {
		esc_html_e( 'An error was encountered attempting to scan this site.', 'it-l10n-backupbuddy' );
		echo '<br>';
		esc_html_e( 'An internet connection is required and this site must be accessible on the public internet.', 'it-l10n-backupbuddy' );
		echo '<br>';
		$scan       = array();
		$continue_2 = false;
	} else {
		$scan = maybe_unserialize( $scan );
	}
}

pb_backupbuddy::$ui->end_metabox();


if ( true === $continue_2 ) {

	if ( ! empty( $scan['MALWARE'] ) && 'E' != $scan['MALWARE'] ) {
		echo '<table><tr><td><img src="' . pb_backupbuddy::plugin_url() . '/images/warning.png" style="width: 92px; height: 92px;" /></td><td><h1>', esc_html__( 'Warning: Possible Malware Detected!', 'it-l10n-backupbuddy' ), '</h1>', esc_html__( 'See details below.', 'it-l10n-backupbuddy' ), '</td></tr></table>';
	}
	?>

	<div class="postbox-container" id="poststuff" style="width: 100%; min-width: 750px;">

		<div id="itbub-malware-div" class="postbox">
			<h3 class="hndle" style="cursor:auto;"><span><?php esc_html_e( 'Malware Detection', 'it-l10n-backupbuddy' ); ?></span></h3>
			<div class="inside">
				<label><?php esc_html_e( 'Malware', 'it-l10n-backupbuddy' ); ?></label>
				<div class="data-line">
					<?php
					if ( ! empty( $scan['MALWARE']['WARN'] ) ) { // Malware found.
						itbub_lined_array( $scan['MALWARE']['WARN'] );
						backupbuddy_core::addNotification( 'malware_found', 'Malware detected on `' . $url . '`.', 'A malware scan was run on the site and detected malware.', array(), true ); // Urgent.
					} else { // No malware found.
						echo '<i>', esc_html__( 'none', 'it-l10n-backupbuddy' ), '</i>';
						backupbuddy_core::addNotification( 'malware_not_found', 'No malware detected on `' . $url . '`.', 'A malware scan was run on the site and did not detect malware.' );
					}
					?>
				</div>
			</div>
		</div>

		<?php
		$default  = '<i>' . esc_html__( 'none', 'it-l10n-backupbuddy' ) . '</i>';
		$sections = array(
			array(
				'title' => __( 'Web Server Details', 'it-l10n-backupbuddy' ),
				'id'    => 'itbub-webserver-div',
				'data'  => array(
					'SITE'   => array(
						'group' => 'SCAN',
						'title' => __( 'Site', 'it-l10n-backupbuddy' ),
					),
					'DOMAIN' => array(
						'group' => 'SCAN',
						'title' => __( 'Hostname', 'it-l10n-backupbuddy' ),
					),
					'IP'     => array(
						'group' => 'SCAN',
						'title' => __( 'IP Address', 'it-l10n-backupbuddy' ),
					),
					'NOTICE' => array(
						'group' => 'SYSTEM',
						'title' => __( 'System Details', 'it-l10n-backupbuddy' ),
					),
					'INFO'   => array(
						'group' => 'SYSTEM',
						'title' => __( 'Information', 'it-l10n-backupbuddy' ),
					),
				),
			),
			array(
				'title' => __( 'Web Application', 'it-l10n-backupbuddy' ),
				'id'    => 'itbub-webapp-div',
				'data'  => array(
					'INFO'    => array(
						'group' => 'WEBAPP',
						'title' => __( 'Details', 'it-l10n-backupbuddy' ),
					),
					'VERSION' => array(
						'group' => 'WEBAPP',
						'title' => __( 'Versions', 'it-l10n-backupbuddy' ),
					),
					'NOTICE'  => array(
						'group' => 'WEBAPP',
						'title' => __( 'Notices', 'it-l10n-backupbuddy' ),
					),
					'ERROR'   => array(
						'group' => 'WEBAPP',
						'title' => __( 'Errors', 'it-l10n-backupbuddy' ),
					),
					'WARN'    => array(
						'group' => 'WEBAPP',
						'title' => __( 'Warnings', 'it-l10n-backupbuddy' ),
					),
				),
			),
			array(
				'title' => __( 'Links', 'it-l10n-backupbuddy' ),
				'id'    => 'itbub-links-div',
				'data'  => array(
					'URL' => array(
						'group' => 'LINKS',
						'title' => '',
					),
				),
			),
			array(
				'title' => __( 'Local Javascript', 'it-l10n-backupbuddy' ),
				'id'    => 'itbub-localjs-div',
				'data'  => array(
					'JSLOCAL' => array(
						'group' => 'LINKS',
						'title' => '',
					),
				),
			),
			array(
				'title' => __( 'External Javascript', 'it-l10n-backupbuddy' ),
				'id'    => 'itbub-externaljs-div',
				'data'  => array(
					'JSEXTERNAL' => array(
						'group' => 'LINKS',
						'title' => '',
					),
				),
			),
			array(
				'title' => __( 'Iframes Included', 'it-l10n-backupbuddy' ),
				'id'    => 'itbub-iframes-div',
				'data'  => array(
					'IFRAME' => array(
						'group' => 'LINKS',
						'title' => '',
					),
				),
			),
			array(
				'title' => __( 'Blacklisting Status', 'it-l10n-backupbuddy' ),
				'id'    => 'itbub-blacklisting-div',
				'data'  => array(
					'INFO' => array(
						'group' => 'BLACKLIST',
						'title' => '',
					),
				),
			),
		);

		foreach ( $sections as $section ) :
			printf( '<div id="%s" class="postbox">', esc_attr( $section['id'] ) );
				printf( '<h3 class="hndle" style="cursor:auto;"><span>%s</span></h3>', esc_attr( $section['title'] ) );
				echo '<div class="inside">';
			foreach ( $section['data'] as $key => $item ) :
				echo '<div class="data-group">';

				if ( ! empty( $item['title'] ) ) :
					printf( '<label>%s</label>', esc_html( $item['title'] ) );
					endif;

				if ( ! empty( $scan[ $item['group'] ][ $key ] ) ) :
					itbub_lined_array( $scan[ $item['group'] ][ $key ] );
					else :
						echo isset( $item['default'] ) ? $item['default'] : $default;
					endif;

					echo '</div><!-- .data-group -->';
					endforeach;
				echo '</div><!-- .inside -->';
			echo '</div><!-- .postbox -->';
		endforeach;
		?>
	</div><!-- .postbox-container -->

	<br><br><br><br>

	<?php
	$perform_scan_link  = is_network_admin() ? network_admin_url( 'admin.php' ) : admin_url( 'admin.php' );
	$perform_scan_link .= '?page=pb_backupbuddy_malware_scan';
	if ( defined( 'pluginbuddy_importbuddy' ) ) :
		$perform_scan_link = page_link( 'malware_scan', 'view_malware' );
	endif;
	$perform_scan_link .= '&refresh=true';
	?>
	<div style="color: #AFAFAF; width: 793px;">
		<a href="<?php echo esc_url( $perform_scan_link ); ?>" class="button-secondary"><?php esc_html_e( 'Perform New Scan Now', 'it-l10n-backupbuddy' ); ?></a>
		<span class="description" style="vertical-align: -4px;">&nbsp;&nbsp;&nbsp;<?php esc_html_e( 'Malware scan results are cached for one hour.', 'it-l10n-backupbuddy' ); ?></span>
	</div>

	<br /><br />
	<?php
} // end $continue_2 check.
